/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.sitemesh;

import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.HTMLPage;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.webwork.sitemesh.TemplatePageFilter;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import com.opensymphony.xwork.ActionContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.context.Context;

public class VelocityPageFilter
extends TemplatePageFilter {
    private static final Log LOG = LogFactory.getLog(VelocityPageFilter.class);

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, ActionContext ctx) throws ServletException, IOException {
        try {
            VelocityManager vm = VelocityManager.getInstance();
            vm.init(servletContext);
            String encoding = this.getEncoding();
            Template template = vm.getVelocityEngine().getTemplate(decorator.getPage(), encoding);
            Context context = vm.createContext(ctx.getValueStack(), req, res);
            context.put("page", (Object)page);
            if (page instanceof HTMLPage) {
                HTMLPage htmlPage = (HTMLPage)page;
                context.put("head", (Object)htmlPage.getHead());
            }
            context.put("title", (Object)page.getTitle());
            context.put("body", (Object)page.getBody());
            PrintWriter writer = res.getWriter();
            template.merge(context, (Writer)writer);
            writer.flush();
        }
        catch (Exception e) {
            String msg = "Error applying decorator: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new ServletException(msg, (Throwable)e);
        }
    }
}

