/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.quickstart;

import com.opensymphony.webwork.quickstart.MultiDirResource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Map;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.FileResource;
import org.mortbay.util.JarResource;
import org.mortbay.util.Resource;

public class MultiWebApplicationContext
extends WebApplicationContext {
    private List pathPriority;
    private Map paths;
    private Class resolver;

    public MultiWebApplicationContext() {
    }

    public MultiWebApplicationContext(List pathPriority, Map paths) {
        super(MultiWebApplicationContext.getFirstRoot(paths));
        this.pathPriority = pathPriority;
        this.paths = paths;
    }

    public MultiWebApplicationContext(List pathPriority, Map paths, String resolver) {
        super(MultiWebApplicationContext.getFirstRoot(paths));
        this.pathPriority = pathPriority;
        this.paths = paths;
        try {
            this.resolver = MultiWebApplicationContext.loadClass(resolver, ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private static String getFirstRoot(Map paths) {
        return (String)((List)paths.get("/")).get(0);
    }

    public Resource getResource(String uriInContext) throws IOException {
        if (uriInContext.startsWith("/WEB-INF/lib/")) {
            String jar = uriInContext.substring("/WEB-INF/lib/".length());
            for (ClassLoader parent = Thread.currentThread().getContextClassLoader(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof URLClassLoader)) continue;
                URL[] urls = ((URLClassLoader)parent).getURLs();
                for (int i = 0; i < urls.length; ++i) {
                    URL url = urls[i];
                    if (!url.toExternalForm().endsWith(jar)) continue;
                    return JarResource.newResource((URL)url);
                }
            }
        }
        if (uriInContext.equals("/webwork")) {
            if (new File("../../src/java/META-INF/taglib.tld").exists()) {
                return FileResource.newResource((String)"../../src/java/META-INF/taglib.tld");
            }
            return FileResource.newResource((String)"src/java/META-INF/taglib.tld");
        }
        MultiDirResource resource = this.newResolver(uriInContext);
        if (resource.exists()) {
            return resource;
        }
        String aliasedUri = this.getResourceAlias(uriInContext);
        if (aliasedUri != null) {
            return super.getResource(aliasedUri);
        }
        return resource;
    }

    public MultiDirResource newResolver(String uriInContext) {
        if (this.resolver == null) {
            return new MultiDirResource(this, uriInContext, this.pathPriority, this.paths);
        }
        try {
            Constructor c = this.resolver.getDeclaredConstructor(MultiWebApplicationContext.class, String.class, List.class, Map.class);
            return (MultiDirResource)((Object)c.newInstance(new Object[]{this, uriInContext, this.pathPriority, this.paths}));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Resource getBaseResource() {
        return this.newResolver("");
    }

    public static Class loadClass(String className, Class callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    return MultiWebApplicationContext.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException exc) {
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
        }
    }
}

