/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.portlet;

import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PortletRequestMap
extends AbstractMap {
    private static final Log LOG = LogFactory.getLog(PortletRequestMap.class);
    private Set entries = null;
    private PortletRequest request = null;

    public PortletRequestMap(PortletRequest request) {
        this.request = request;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Dumping request parameters: ");
            for (String key : request.getParameterMap().keySet()) {
                String val = request.getParameter(key);
                LOG.debug((Object)(key + " = " + val));
            }
        }
    }

    public void clear() {
        this.entries = null;
        Enumeration keys = this.request.getAttributeNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.request.removeAttribute(key);
        }
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new HashSet();
            Enumeration enumeration = this.request.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                final String key = enumeration.nextElement().toString();
                final Object value = this.request.getAttribute(key);
                this.entries.add(new Map.Entry(){

                    public boolean equals(Object obj) {
                        Map.Entry entry = (Map.Entry)obj;
                        return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    public Object setValue(Object obj) {
                        PortletRequestMap.this.request.setAttribute(key, obj);
                        return value;
                    }
                });
            }
        }
        return this.entries;
    }

    public Object get(Object key) {
        return this.request.getAttribute(key.toString());
    }

    public Object put(Object key, Object value) {
        this.entries = null;
        this.request.setAttribute(key.toString(), value);
        return this.get(key);
    }

    public Object remove(Object key) {
        this.entries = null;
        Object value = this.get(key);
        this.request.removeAttribute(key.toString());
        return value;
    }
}

