/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.webwork.dispatcher.SessionMap;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.interceptor.AroundInterceptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionInvalidationInterceptor
extends AroundInterceptor {
    private static final Log LOG = LogFactory.getLog(SessionInvalidationInterceptor.class);
    private static final long serialVersionUID = 1L;
    public static String NEXT_REQUEST = "NextRequest";
    public static String NOW = "Now";
    public static String NO_OPERATION = "NoOperation";
    protected String key = "___invalidateSession";
    protected String type = NO_OPERATION;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
        SessionMap sessionMap = (SessionMap)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.ActionContext.session");
        if (NOW.equalsIgnoreCase(this.type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"type=now, invalidating session now");
            }
            sessionMap.invalidate();
            LOG.info((Object)"session invalidated");
        } else if (NEXT_REQUEST.equalsIgnoreCase(this.type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"type=NextRequest, mark key in session, such that next request that have this interceptor will invalidate the session");
            }
            sessionMap.put(this.key, "true");
        } else if (NO_OPERATION.equalsIgnoreCase(this.type)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"no operation");
            }
        } else {
            LOG.warn((Object)("unrecognized type, type should be either " + NOW + ", " + NEXT_REQUEST + " or " + NO_OPERATION));
        }
    }

    protected void before(ActionInvocation invocation) throws Exception {
        SessionMap sessionMap = (SessionMap)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.ActionContext.session");
        if (sessionMap.containsKey(this.key) && sessionMap.get(this.key).equals("true")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"found marker in session indicating this is the 'next request', session should be invalidated");
            }
            sessionMap.invalidate();
            LOG.info((Object)"session invalidated");
        }
    }
}

