/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.interceptor;

import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageStoreInterceptor
implements Interceptor {
    private static final long serialVersionUID = 4491997514314242420L;
    private static final Log _log = LogFactory.getLog(MessageStoreInterceptor.class);
    public static final String STORE_MODE = "STORE";
    public static final String RETRIEVE_MODE = "RETRIEVE";
    public static final String NONE = "NONE";
    private boolean allowRequestParameterSwitch = true;
    private String requestParameterSwitch = "operationMode";
    private String operationMode = "NONE";
    public static String fieldErrorsSessionKey = "__MessageStoreInterceptor_FieldErrors_SessionKey";
    public static String actionErrorsSessionKey = "__MessageStoreInterceptor_ActionErrors_SessionKey";
    public static String actionMessagesSessionKey = "__MessageStoreInterceptor_ActionMessages_SessionKey";

    public void setAllowRequestParameterSwitch(boolean allowRequestParameterSwitch) {
        this.allowRequestParameterSwitch = allowRequestParameterSwitch;
    }

    public boolean getAllowRequestParameterSwitch() {
        return this.allowRequestParameterSwitch;
    }

    public void setRequestParameterSwitch(String requestParameterSwitch) {
        this.requestParameterSwitch = requestParameterSwitch;
    }

    public String getRequestParameterSwitch() {
        return this.requestParameterSwitch;
    }

    public void setOperationMode(String operationMode) {
        this.operationMode = operationMode;
    }

    public String getOperationModel() {
        return this.operationMode;
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        _log.debug((Object)"entering MessageStoreInterceptor ...");
        this.before(invocation);
        String result = invocation.invoke();
        this.after(invocation, result);
        _log.debug((Object)"exit executing MessageStoreInterceptor");
        return result;
    }

    protected void before(ActionInvocation invocation) throws Exception {
        Object action;
        String reqOperationMode = this.getRequestOperationMode(invocation);
        if ((RETRIEVE_MODE.equalsIgnoreCase(reqOperationMode) || RETRIEVE_MODE.equalsIgnoreCase(this.operationMode)) && (action = invocation.getAction()) instanceof ValidationAware) {
            Map session = (Map)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.ActionContext.session");
            ValidationAware validationAwareAction = (ValidationAware)action;
            _log.debug((Object)("retrieve error / message from session to populate into action [" + action + "]"));
            Collection actionErrors = (Collection)session.get(actionErrorsSessionKey);
            Collection actionMessages = (Collection)session.get(actionMessagesSessionKey);
            Map fieldErrors = (Map)session.get(fieldErrorsSessionKey);
            if (actionErrors != null && actionErrors.size() > 0) {
                Collection mergedActionErrors = this.mergeCollection(validationAwareAction.getActionErrors(), actionErrors);
                validationAwareAction.setActionErrors(mergedActionErrors);
            }
            if (actionMessages != null && actionMessages.size() > 0) {
                Collection mergedActionMessages = this.mergeCollection(validationAwareAction.getActionMessages(), actionMessages);
                validationAwareAction.setActionMessages(mergedActionMessages);
            }
            if (fieldErrors != null && fieldErrors.size() > 0) {
                Map mergedFieldErrors = this.mergeMap(validationAwareAction.getFieldErrors(), fieldErrors);
                validationAwareAction.setFieldErrors(mergedFieldErrors);
            }
            session.remove(actionErrorsSessionKey);
            session.remove(actionMessagesSessionKey);
            session.remove(fieldErrorsSessionKey);
        }
    }

    protected void after(ActionInvocation invocation, String result) throws Exception {
        String reqOperationMode = this.getRequestOperationMode(invocation);
        if (STORE_MODE.equalsIgnoreCase(reqOperationMode) || STORE_MODE.equalsIgnoreCase(this.operationMode)) {
            Object action = invocation.getAction();
            if (action instanceof ValidationAware) {
                Map session = (Map)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.ActionContext.session");
                _log.debug((Object)("store action [" + action + "] error/messages into session "));
                ValidationAware validationAwareAction = (ValidationAware)action;
                session.put(actionErrorsSessionKey, validationAwareAction.getActionErrors());
                session.put(actionMessagesSessionKey, validationAwareAction.getActionMessages());
                session.put(fieldErrorsSessionKey, validationAwareAction.getFieldErrors());
            } else {
                _log.debug((Object)("Action [" + action + "] is not ValidationAware, no message / error that are storeable"));
            }
        }
    }

    protected String getRequestOperationMode(ActionInvocation invocation) {
        String[] reqParamsArr;
        Map reqParams;
        boolean containsParameter;
        String reqOperationMode = NONE;
        if (this.allowRequestParameterSwitch && (containsParameter = (reqParams = (Map)invocation.getInvocationContext().get((Object)"com.opensymphony.xwork.ActionContext.parameters")).containsKey(this.requestParameterSwitch)) && (reqParamsArr = (String[])reqParams.get(this.requestParameterSwitch)) != null && reqParamsArr.length > 0) {
            reqOperationMode = reqParamsArr[0];
        }
        return reqOperationMode;
    }

    protected Collection mergeCollection(Collection col1, Collection col2) {
        Collection _col1 = col1 == null ? new ArrayList() : col1;
        Collection _col2 = col2 == null ? new ArrayList() : col2;
        _col1.addAll(_col2);
        return _col1;
    }

    protected Map mergeMap(Map map1, Map map2) {
        Map _map1 = map1 == null ? new LinkedHashMap() : map1;
        Map _map2 = map2 == null ? new LinkedHashMap() : map2;
        _map1.putAll(_map2);
        return _map1;
    }
}

