/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components.template;

import com.opensymphony.webwork.components.template.BaseTemplateEngine;
import com.opensymphony.webwork.components.template.Template;
import com.opensymphony.webwork.components.template.TemplateRenderingContext;
import com.opensymphony.webwork.views.velocity.VelocityManager;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityTemplateEngine
extends BaseTemplateEngine {
    private static final Log LOG = LogFactory.getLog(VelocityTemplateEngine.class);

    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Map actionContext = templateContext.getStack().getContext();
        ServletContext servletContext = (ServletContext)actionContext.get("com.opensymphony.xwork.dispatcher.ServletContext");
        HttpServletRequest req = (HttpServletRequest)actionContext.get("com.opensymphony.xwork.dispatcher.HttpServletRequest");
        HttpServletResponse res = (HttpServletResponse)actionContext.get("com.opensymphony.xwork.dispatcher.HttpServletResponse");
        VelocityManager velocityManager = VelocityManager.getInstance();
        velocityManager.init(servletContext);
        VelocityEngine velocityEngine = velocityManager.getVelocityEngine();
        List templates = templateContext.getTemplate().getPossibleTemplates(this);
        org.apache.velocity.Template template = null;
        String templateName = null;
        IOException exception = null;
        for (Template t : templates) {
            templateName = this.getFinalTemplateName(t);
            try {
                template = velocityEngine.getTemplate(templateName);
                break;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (template == null) {
            LOG.error((Object)("Could not load template " + templateContext.getTemplate()));
            if (exception != null) {
                throw exception;
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rendering template " + templateName));
        }
        Context context = velocityManager.createContext(templateContext.getStack(), req, res);
        Writer outputWriter = templateContext.getWriter();
        context.put("tag", (Object)templateContext.getTag());
        context.put("parameters", (Object)templateContext.getParameters());
        template.merge(context, outputWriter);
    }

    protected String getSuffix() {
        return "vm";
    }
}

