/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.WebWorkException;
import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.dispatcher.DispatcherUtils;
import com.opensymphony.webwork.portlet.context.PortletActionContext;
import com.opensymphony.webwork.portlet.util.PortletUrlHelper;
import com.opensymphony.webwork.views.util.UrlHelper;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class URL
extends Component {
    private static final Log LOG = LogFactory.getLog(URL.class);
    public static final String NONE = "none";
    public static final String GET = "get";
    public static final String ALL = "all";
    private HttpServletRequest req;
    private HttpServletResponse res;
    protected String includeParams;
    protected String scheme;
    protected String value;
    protected String action;
    protected String namespace;
    protected String method;
    protected boolean encode = true;
    protected boolean includeContext = true;
    protected String portletMode;
    protected String windowState;
    protected String portletUrlType;
    protected String anchor;
    protected boolean escapeAmp = true;

    public URL(OgnlValueStack stack, HttpServletRequest req, HttpServletResponse res) {
        super(stack);
        this.req = req;
        this.res = res;
    }

    public boolean start(Writer writer) {
        boolean result = super.start(writer);
        if (this.value != null) {
            this.value = this.findString(this.value);
        }
        try {
            String includeParams;
            String string = includeParams = Configuration.isSet("webwork.url.includeParams") ? Configuration.getString("webwork.url.includeParams").toLowerCase() : GET;
            if (this.includeParams != null) {
                includeParams = this.findString(this.includeParams);
            }
            if (NONE.equalsIgnoreCase(includeParams)) {
                this.mergeRequestParameters(this.value, this.parameters, Collections.EMPTY_MAP);
                ActionContext.getContext().put((Object)"__continue", null);
            } else if (ALL.equalsIgnoreCase(includeParams)) {
                this.mergeRequestParameters(this.value, this.parameters, this.req.getParameterMap());
                this.includeGetParameters();
            } else if (GET.equalsIgnoreCase(includeParams) || includeParams == null && this.value == null && this.action == null) {
                this.includeGetParameters();
            } else if (includeParams != null) {
                LOG.warn((Object)("Unknown value for includeParams parameter to URL tag: " + includeParams));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to put request parameters (" + this.extractQueryString() + ") into parameter map."), (Throwable)e);
        }
        return result;
    }

    private void includeGetParameters() {
        if (!DispatcherUtils.isPortletSupportActive() || !PortletActionContext.isPortletRequest()) {
            String query = this.extractQueryString();
            this.mergeRequestParameters(this.value, this.parameters, UrlHelper.parseQueryString(query));
        }
    }

    private String extractQueryString() {
        int idx;
        String query = this.req.getQueryString();
        if (query == null) {
            query = (String)this.req.getAttribute("javax.servlet.forward.query_string");
        }
        if (query != null && (idx = query.lastIndexOf(35)) != -1) {
            query = query.substring(0, idx);
        }
        return query;
    }

    public boolean end(Writer writer, String body) {
        String id;
        String result;
        String scheme = this.req.getScheme();
        if (this.scheme != null) {
            scheme = this.scheme;
        }
        if (this.value == null && this.action != null) {
            result = DispatcherUtils.isPortletSupportActive() && PortletActionContext.isPortletRequest() ? PortletUrlHelper.buildUrl(this.action, this.namespace, this.parameters, this.portletUrlType, this.portletMode, this.windowState) : this.determineActionURL(this.action, this.namespace, this.method, this.req, this.res, this.parameters, scheme, this.includeContext, this.encode, this.escapeAmp);
        } else if (DispatcherUtils.isPortletSupportActive() && PortletActionContext.isPortletRequest()) {
            result = PortletUrlHelper.buildResourceUrl(this.value, this.parameters);
        } else {
            String _value = this.value;
            if (_value != null && _value.indexOf("?") > 0) {
                _value = _value.substring(0, _value.indexOf("?"));
            }
            result = UrlHelper.buildUrl(_value, this.req, this.res, this.parameters, scheme, this.includeContext, this.encode, false, this.escapeAmp);
        }
        if (this.anchor != null && this.anchor.length() > 0) {
            result = result + '#' + this.anchor;
        }
        if ((id = this.getId()) != null) {
            this.getStack().getContext().put(id, result);
            this.req.setAttribute(id, (Object)result);
        } else {
            try {
                writer.write(result);
            }
            catch (IOException e) {
                throw new WebWorkException("IOError: " + e.getMessage(), e);
            }
        }
        return super.end(writer, body);
    }

    public void setIncludeParams(String includeParams) {
        this.includeParams = includeParams;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setEncode(boolean encode) {
        this.encode = encode;
    }

    public void setIncludeContext(boolean includeContext) {
        this.includeContext = includeContext;
    }

    public void setPortletMode(String portletMode) {
        this.portletMode = portletMode;
    }

    public void setWindowState(String windowState) {
        this.windowState = windowState;
    }

    public void setPortletUrlType(String portletUrlType) {
        this.portletUrlType = portletUrlType;
    }

    public void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    public void setEscapeAmp(boolean escapeAmp) {
        this.escapeAmp = escapeAmp;
    }

    protected void mergeRequestParameters(String value, Map parameters, Map contextParameters) {
        Map mergedParams = new LinkedHashMap(contextParameters);
        if (value != null && value.trim().length() > 0 && value.indexOf("?") > 0) {
            mergedParams = new LinkedHashMap();
            String queryString = value.substring(value.indexOf("?") + 1);
            mergedParams = UrlHelper.parseQueryString(queryString);
            for (Map.Entry entry : contextParameters.entrySet()) {
                Object key = entry.getKey();
                if (mergedParams.containsKey(key)) continue;
                mergedParams.put(key, entry.getValue());
            }
        }
        for (Map.Entry entry : mergedParams.entrySet()) {
            Object key = entry.getKey();
            if (parameters.containsKey(key)) continue;
            parameters.put(key, entry.getValue());
        }
    }
}

