/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.Component;
import com.opensymphony.webwork.util.MakeIterator;
import com.opensymphony.webwork.views.jsp.IteratorStatus;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.io.Writer;
import java.util.Iterator;

public class IteratorComponent
extends Component {
    protected Iterator iterator;
    protected IteratorStatus status;
    protected Object oldStatus;
    protected IteratorStatus.StatusState statusState;
    protected String statusAttr;
    protected String value;

    public IteratorComponent(OgnlValueStack stack) {
        super(stack);
    }

    public boolean start(Writer writer) {
        if (this.statusAttr != null) {
            this.statusState = new IteratorStatus.StatusState();
            this.status = new IteratorStatus(this.statusState);
        }
        OgnlValueStack stack = this.getStack();
        if (this.value == null) {
            this.value = "top";
        }
        this.iterator = MakeIterator.convert(this.findValue(this.value));
        if (this.iterator != null && this.iterator.hasNext()) {
            Object currentValue = this.iterator.next();
            stack.push(currentValue);
            String id = this.getId();
            if (id != null && currentValue != null) {
                stack.getContext().put(id, currentValue);
            }
            if (this.statusAttr != null) {
                this.statusState.setLast(!this.iterator.hasNext());
                this.oldStatus = stack.getContext().get(this.statusAttr);
                stack.getContext().put(this.statusAttr, this.status);
            }
            return true;
        }
        super.end(writer, "");
        return false;
    }

    public boolean end(Writer writer, String body) {
        OgnlValueStack stack = this.getStack();
        if (this.iterator != null) {
            stack.pop();
        }
        if (this.iterator != null && this.iterator.hasNext()) {
            Object currentValue = this.iterator.next();
            stack.push(currentValue);
            String id = this.getId();
            if (id != null && currentValue != null) {
                stack.getContext().put(id, currentValue);
            }
            if (this.status != null) {
                this.statusState.next();
                this.statusState.setLast(!this.iterator.hasNext());
            }
            return true;
        }
        if (this.status != null) {
            if (this.oldStatus == null) {
                stack.getContext().put(this.statusAttr, null);
            } else {
                stack.getContext().put(this.statusAttr, this.oldStatus);
            }
        }
        super.end(writer, "");
        return false;
    }

    public void setStatus(String status) {
        this.statusAttr = status;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

