/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util.thumbnail;

public class Thumbnail {
    private int height;
    private int width;
    private String filename;
    private long attachmentId;
    private MimeType mimeType;

    public Thumbnail(int height, int width, String fileName, long attachmentId) {
        this(height, width, fileName, attachmentId, MimeType.JPG);
    }

    public Thumbnail(int height, int width, String filename, long attachmentId, MimeType mimeType) {
        this.height = height;
        this.width = width;
        this.mimeType = mimeType;
        this.filename = filename;
        this.attachmentId = attachmentId;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getAttachmentId() {
        return this.attachmentId;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return "Thumbnail " + (Object)((Object)this.mimeType) + " " + this.filename + " width:" + this.width + " height:" + this.height;
    }

    public static enum MimeType {
        JPG("image/jpeg"),
        PNG("image/png");

        private final String name;

        private MimeType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

