/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private static final ReplacePolicy DEFAULT_POLICY = new ReplacePolicy();
    private static int _lastPrintable = 126;

    public static String getContainedText(Node parent, String childTagName) {
        try {
            Node tag = ((Element)parent).getElementsByTagName(childTagName).item(0);
            return ((Text)tag.getFirstChild()).getData();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Element getSingleChildElement(Element el, String name) {
        NodeList children = el.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1 || !name.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getAttributeWithDefault(Element element, String attributeName, String defaultValue) {
        String group = element.getAttribute(attributeName);
        if (group == null || "".equals(group.trim())) {
            group = defaultValue;
        }
        return group;
    }

    public static String escape(String source, TransformPolicy policy) {
        if (source == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(source.length() + 30);
        for (int i = 0; i < source.length(); ++i) {
            XMLUtils.transform(sb, source.charAt(i), policy);
        }
        return sb.toString();
    }

    public static String escape(String source) {
        return XMLUtils.escape(source, (TransformPolicy)DEFAULT_POLICY);
    }

    public static String escapeForCdata(String source) {
        int index;
        if (source == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int oldIndex = 0;
        while ((index = source.indexOf("]]>", oldIndex)) > -1) {
            String str = source.substring(oldIndex, index);
            XMLUtils.transformCData(sb, str, DEFAULT_POLICY);
            oldIndex = index + 3;
            sb.append("]]]]><![CDATA[>");
        }
        String rest = source.substring(oldIndex);
        XMLUtils.transformCData(sb, rest, DEFAULT_POLICY);
        return sb.toString();
    }

    private static String getEntityRef(char ch) {
        switch (ch) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    public static String escape(char ch) {
        return XMLUtils.escape(ch, (TransformPolicy)DEFAULT_POLICY);
    }

    public static String escape(char ch, TransformPolicy policy) {
        StringBuilder sb = new StringBuilder();
        XMLUtils.transform(sb, ch, policy);
        return sb.toString();
    }

    private static void transform(StringBuilder sb, char ch, TransformPolicy policy) {
        if (!XMLUtils.validXml(ch)) {
            sb.append(policy.handle(ch));
        } else {
            String charRef = XMLUtils.getEntityRef(ch);
            if (charRef != null) {
                sb.append("&").append(charRef).append(";");
            } else if (ch >= ' ' && ch <= _lastPrintable && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t') {
                sb.append(ch);
            } else {
                sb.append("&#").append(Integer.toString(ch)).append(";");
            }
        }
    }

    private static void transformCData(StringBuilder sb, String cdata, TransformPolicy policy) {
        for (int i = 0; i < cdata.toCharArray().length; ++i) {
            char ch = cdata.toCharArray()[i];
            if (!XMLUtils.validXml(ch)) {
                sb.append(policy.handle(ch));
                continue;
            }
            sb.append(ch);
        }
    }

    public static boolean validXml(char ch) {
        return ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff';
    }

    public static class ReplacePolicy
    implements TransformPolicy {
        @Override
        public String handle(char input) {
            return "\ufffd";
        }
    }

    public static interface TransformPolicy {
        public String handle(char var1);
    }
}

