/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.task;

import com.atlassian.core.task.AbstractTaskQueue;
import com.atlassian.core.task.FifoBuffer;
import com.atlassian.core.task.Task;
import com.atlassian.core.task.TaskQueue;
import com.atlassian.core.task.TaskQueueWithErrorQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class AbstractErrorQueuedTaskQueue
extends AbstractTaskQueue
implements TaskQueueWithErrorQueue {
    private static final transient Logger log = Logger.getLogger(AbstractErrorQueuedTaskQueue.class);
    private TaskQueue errorQueue;
    private int retryCount = 5;
    private List failed;

    public AbstractErrorQueuedTaskQueue(TaskQueue errorQueue, FifoBuffer buffer) {
        super(buffer);
        this.errorQueue = errorQueue;
    }

    @Override
    public void flush() {
        this.failed = new ArrayList();
        super.flush();
        Iterator iterator = this.failed.iterator();
        while (iterator.hasNext()) {
            this.addTask((Task)iterator.next());
        }
    }

    @Override
    protected void handleException(Task task, Exception rootException) {
        TaskDecorator theTask = (TaskDecorator)task;
        if (theTask.getExecutionCount() > this.retryCount) {
            this.errorQueue.addTask(theTask.getTask());
        } else {
            this.failed.add(task);
        }
        if (rootException instanceof MessagingException) {
            Exception e = rootException;
            while (e instanceof MessagingException) {
                MessagingException me = (MessagingException)e;
                log.error((Object)me.getMessage(), (Throwable)me);
                e = me.getNextException();
            }
        } else {
            log.error((Object)rootException, (Throwable)rootException);
        }
    }

    @Override
    public void addTask(Task task) {
        if (task instanceof TaskDecorator) {
            super.addTask(task);
        } else {
            super.addTask(new TaskDecorator(task));
        }
    }

    @Override
    public TaskQueue getErrorQueue() {
        return this.errorQueue;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public static class TaskDecorator
    implements Task,
    Serializable {
        private Task task;
        private int executionCount = 0;

        public TaskDecorator(Task task) {
            this.task = task;
        }

        @Override
        public void execute() throws Exception {
            ++this.executionCount;
            this.task.execute();
        }

        public int getExecutionCount() {
            return this.executionCount;
        }

        public Task getTask() {
            return this.task;
        }
    }
}

