/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.parser.TokenQueue;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector {
    private static final String[] combinators = new String[]{",", ">", "+", "~", " "};
    private final Element root;
    private final LinkedHashSet<Element> elements;
    private final String query;
    private final TokenQueue tq;

    private Selector(String query, Element root) {
        Validate.notNull((Object)query);
        query = query.trim();
        Validate.notEmpty((String)query);
        Validate.notNull((Object)root);
        this.elements = new LinkedHashSet();
        this.query = query;
        this.root = root;
        this.tq = new TokenQueue(query);
    }

    public static Elements select(String query, Element root) {
        return new Selector(query, root).select();
    }

    public static Elements select(String query, Iterable<Element> roots) {
        Validate.notEmpty((String)query);
        Validate.notNull(roots);
        LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
        for (Element root : roots) {
            elements.addAll(Selector.select(query, root));
        }
        return new Elements(elements);
    }

    private Elements select() {
        this.tq.consumeWhitespace();
        if (this.tq.matchesAny(combinators)) {
            this.elements.add(this.root);
            this.combinator(this.tq.consume().toString());
        } else {
            this.addElements(this.findElements());
        }
        while (!this.tq.isEmpty()) {
            boolean seenWhite = this.tq.consumeWhitespace();
            if (this.tq.matchChomp(",")) {
                while (!this.tq.isEmpty()) {
                    String subQuery = this.tq.chompTo(",");
                    this.elements.addAll(Selector.select(subQuery, this.root));
                }
                continue;
            }
            if (this.tq.matchesAny(combinators)) {
                this.combinator(this.tq.consume().toString());
                continue;
            }
            if (seenWhite) {
                this.combinator(" ");
                continue;
            }
            Elements candidates = this.findElements();
            this.intersectElements(Selector.filterForSelf(this.elements, candidates));
        }
        return new Elements(this.elements);
    }

    private void combinator(String combinator) {
        Elements output;
        this.tq.consumeWhitespace();
        String subQuery = this.tq.consumeToAny(combinators);
        if (combinator.equals(">")) {
            output = Selector.filterForChildren(this.elements, Selector.select(subQuery, this.elements));
        } else if (combinator.equals(" ")) {
            output = Selector.filterForDescendants(this.elements, Selector.select(subQuery, this.elements));
        } else if (combinator.equals("+")) {
            output = Selector.filterForAdjacentSiblings(this.elements, Selector.select(subQuery, this.root));
        } else if (combinator.equals("~")) {
            output = Selector.filterForGeneralSiblings(this.elements, Selector.select(subQuery, this.root));
        } else {
            throw new IllegalStateException("Unknown combinator: " + combinator);
        }
        this.elements.clear();
        this.elements.addAll(output);
    }

    private Elements findElements() {
        if (this.tq.matchChomp("#")) {
            return this.byId();
        }
        if (this.tq.matchChomp(".")) {
            return this.byClass();
        }
        if (this.tq.matchesWord()) {
            return this.byTag();
        }
        if (this.tq.matchChomp("[")) {
            return this.byAttribute();
        }
        if (this.tq.matchChomp("*")) {
            return this.allElements();
        }
        if (this.tq.matchChomp(":lt(")) {
            return this.indexLessThan();
        }
        if (this.tq.matchChomp(":gt(")) {
            return this.indexGreaterThan();
        }
        if (this.tq.matchChomp(":eq(")) {
            return this.indexEquals();
        }
        throw new SelectorParseException("Could not parse query " + this.query);
    }

    private void addElements(Collection<Element> add) {
        this.elements.addAll(add);
    }

    private void intersectElements(Collection<Element> intersect) {
        this.elements.retainAll(intersect);
    }

    private Elements byId() {
        String id = this.tq.consumeCssIdentifier();
        Validate.notEmpty((String)id);
        Element found = this.root.getElementById(id);
        Elements byId = new Elements();
        if (found != null) {
            byId.add(found);
        }
        return byId;
    }

    private Elements byClass() {
        String className = this.tq.consumeCssIdentifier();
        Validate.notEmpty((String)className);
        return this.root.getElementsByClass(className);
    }

    private Elements byTag() {
        String tagName = this.tq.consumeWord();
        Validate.notEmpty((String)tagName);
        return this.root.getElementsByTag(tagName);
    }

    private Elements byAttribute() {
        String key = this.tq.consumeToAny("=", "!=", "^=", "$=", "*=", "]");
        Validate.notEmpty((String)key);
        if (this.tq.matchChomp("]")) {
            return this.root.getElementsByAttribute(key);
        }
        if (this.tq.matchChomp("=")) {
            return this.root.getElementsByAttributeValue(key, this.tq.chompTo("]"));
        }
        if (this.tq.matchChomp("!=")) {
            return this.root.getElementsByAttributeValueNot(key, this.tq.chompTo("]"));
        }
        if (this.tq.matchChomp("^=")) {
            return this.root.getElementsByAttributeValueStarting(key, this.tq.chompTo("]"));
        }
        if (this.tq.matchChomp("$=")) {
            return this.root.getElementsByAttributeValueEnding(key, this.tq.chompTo("]"));
        }
        if (this.tq.matchChomp("*=")) {
            return this.root.getElementsByAttributeValueContaining(key, this.tq.chompTo("]"));
        }
        throw new SelectorParseException("Could not parse attribute query " + this.query);
    }

    private Elements allElements() {
        return this.root.getAllElements();
    }

    private Elements indexLessThan() {
        return this.root.getElementsByIndexLessThan(this.consumeIndex());
    }

    private Elements indexGreaterThan() {
        return this.root.getElementsByIndexGreaterThan(this.consumeIndex());
    }

    private Elements indexEquals() {
        return this.root.getElementsByIndexEquals(this.consumeIndex());
    }

    private int consumeIndex() {
        String indexS = this.tq.chompTo(")").trim();
        Validate.isTrue((boolean)StringUtils.isNumeric((String)indexS), (String)"Index must be numeric");
        int index = Integer.parseInt(indexS);
        return index;
    }

    private static Elements filterForChildren(Collection<Element> parents, Collection<Element> candidates) {
        Elements children = new Elements();
        block0: for (Element c : candidates) {
            for (Element p : parents) {
                if (c.parent() == null || !c.parent().equals(p)) continue;
                children.add(c);
                continue block0;
            }
        }
        return children;
    }

    private static Elements filterForDescendants(Collection<Element> parents, Collection<Element> candidates) {
        Elements children = new Elements();
        block0: for (Element c : candidates) {
            boolean found = false;
            for (Element p : parents) {
                if (!c.equals(p)) continue;
                found = true;
                continue block0;
            }
            if (found) continue;
            children.add(c);
        }
        return children;
    }

    private static Elements filterForAdjacentSiblings(Collection<Element> elements, Collection<Element> candidates) {
        Elements siblings = new Elements();
        block0: for (Element c : candidates) {
            for (Element e : elements) {
                Element previousSib;
                if (!e.parent().equals(c.parent()) || (previousSib = c.previousElementSibling()) == null || !previousSib.equals(e)) continue;
                siblings.add(c);
                continue block0;
            }
        }
        return siblings;
    }

    private static Elements filterForGeneralSiblings(Collection<Element> elements, Collection<Element> candidates) {
        Elements output = new Elements();
        block0: for (Element c : candidates) {
            for (Element e : elements) {
                if (!e.parent().equals(c.parent())) continue;
                int ePos = e.elementSiblingIndex();
                int cPos = c.elementSiblingIndex();
                if (cPos <= ePos) continue;
                output.add(c);
                continue block0;
            }
        }
        return output;
    }

    private static Elements filterForSelf(Collection<Element> parents, Collection<Element> candidates) {
        Elements children = new Elements();
        block0: for (Element c : candidates) {
            for (Element p : parents) {
                if (!c.equals(p)) continue;
                children.add(c);
                continue block0;
            }
        }
        return children;
    }

    public static class SelectorParseException
    extends IllegalStateException {
        public SelectorParseException(String s) {
            super(s);
        }
    }
}

