/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.Validate;

public class TokenQueue {
    private LinkedList<Character> queue;

    public TokenQueue(String data) {
        char[] chars;
        Validate.notNull((Object)data);
        this.queue = new LinkedList();
        for (char c : chars = data.toCharArray()) {
            this.queue.add(Character.valueOf(c));
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Character peek() {
        return this.queue.peek();
    }

    public void addFirst(Character c) {
        this.queue.addFirst(c);
    }

    public void addFirst(String seq) {
        char[] chars = seq.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            this.addFirst(Character.valueOf(chars[i]));
        }
    }

    public boolean matches(String seq) {
        int len = seq.length();
        if (len > this.queue.size()) {
            return false;
        }
        List chars = this.queue.subList(0, len);
        char[] seqChars = seq.toCharArray();
        for (int i = 0; i < len; ++i) {
            Character check;
            Character found = Character.valueOf(Character.toLowerCase(((Character)chars.get(i)).charValue()));
            if (found.equals(check = Character.valueOf(Character.toLowerCase(seqChars[i])))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesAny(String ... seq) {
        for (String s : seq) {
            if (!this.matches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean matchChomp(String seq) {
        if (this.matches(seq)) {
            this.consume(seq);
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.queue.isEmpty() && Character.isWhitespace(this.queue.peek().charValue());
    }

    public boolean matchesWord() {
        return !this.queue.isEmpty() && Character.isLetterOrDigit(this.queue.peek().charValue());
    }

    public Character consume() {
        return this.queue.removeFirst();
    }

    public void consume(String seq) {
        if (!this.matches(seq)) {
            throw new IllegalStateException("Queue did not match expected sequence");
        }
        int len = seq.length();
        if (len > this.queue.size()) {
            throw new IllegalStateException("Queue not long enough to consume sequence");
        }
        for (int i = 0; i < len; ++i) {
            this.consume();
        }
    }

    public String consumeTo(String seq) {
        return this.consumeToAny(seq);
    }

    public String consumeToAny(String ... seq) {
        StringBuilder accum = new StringBuilder();
        while (!this.queue.isEmpty() && !this.matchesAny(seq)) {
            accum.append(this.consume());
        }
        return accum.toString();
    }

    public String chompTo(String seq) {
        String data = this.consumeTo(seq);
        this.matchChomp(seq);
        return data;
    }

    public boolean consumeWhitespace() {
        boolean seen = false;
        while (!this.queue.isEmpty() && Character.isWhitespace(this.queue.peek().charValue())) {
            this.consume();
            seen = true;
        }
        return seen;
    }

    public String consumeWord() {
        StringBuilder wordAccum = new StringBuilder();
        while (!this.queue.isEmpty() && Character.isLetterOrDigit(this.queue.peek().charValue())) {
            wordAccum.append(this.queue.removeFirst());
        }
        return wordAccum.toString();
    }

    public String consumeCssIdentifier() {
        StringBuilder accum = new StringBuilder();
        Character c = this.queue.peek();
        while (!this.queue.isEmpty() && (Character.isLetterOrDigit(c.charValue()) || c.equals(Character.valueOf('-')) || c.equals(Character.valueOf('_')))) {
            accum.append(this.queue.removeFirst());
            c = this.queue.peek();
        }
        return accum.toString();
    }

    public String consumeAttributeKey() {
        StringBuilder accum = new StringBuilder();
        while (!this.queue.isEmpty() && (Character.isLetterOrDigit(this.queue.peek().charValue()) || this.matchesAny("-", "_", ":"))) {
            accum.append(this.queue.removeFirst());
        }
        return accum.toString();
    }

    public String remainder() {
        StringBuilder accum = new StringBuilder();
        while (!this.queue.isEmpty()) {
            accum.append(this.consume());
        }
        return accum.toString();
    }

    public String toString() {
        return this.queue.toString();
    }
}

