/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class Tag {
    private static final Map<String, Tag> tags = new HashMap<String, Tag>();
    private static final Tag defaultAncestor = new Tag("BODY");
    private String tagName;
    private boolean isBlock = true;
    private boolean canContainBlock = true;
    private boolean canContainInline = true;
    private boolean optionalClosing = false;
    private boolean empty = false;
    private boolean preserveWhitespace = false;
    private List<Tag> ancestors;

    private Tag(String tagName) {
        this.tagName = tagName.toLowerCase();
    }

    public String getName() {
        return this.tagName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tag valueOf(String tagName) {
        Validate.notNull((Object)tagName);
        tagName = tagName.trim().toLowerCase();
        Validate.notEmpty((String)tagName);
        Map<String, Tag> map = tags;
        synchronized (map) {
            Tag tag = tags.get(tagName);
            if (tag == null) {
                tag = new Tag(tagName);
                tag.setAncestor(Tag.defaultAncestor.tagName);
                tag.isBlock = false;
                tag.canContainBlock = true;
            }
            return tag;
        }
    }

    boolean canContain(Tag child) {
        Validate.notNull((Object)child);
        if (child.isBlock && !this.canContainBlock) {
            return false;
        }
        if (!child.isBlock && !this.canContainInline) {
            return false;
        }
        if (this.optionalClosing && this.equals(child)) {
            return false;
        }
        if (this.empty || this.isData()) {
            return false;
        }
        if (this.tagName.equals("head")) {
            return child.tagName.equals("base") || child.tagName.equals("script") || child.tagName.equals("noscript") || child.tagName.equals("link") || child.tagName.equals("meta") || child.tagName.equals("title") || child.tagName.equals("style") || child.tagName.equals("object");
        }
        if (this.tagName.equals("dt") && child.tagName.equals("dd")) {
            return false;
        }
        return !this.tagName.equals("dd") || !child.tagName.equals("dt");
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public boolean canContainBlock() {
        return this.canContainBlock;
    }

    public boolean isInline() {
        return !this.isBlock;
    }

    public boolean isData() {
        return !this.canContainInline && !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean preserveWhitespace() {
        return this.preserveWhitespace;
    }

    Tag getImplicitParent() {
        return !this.ancestors.isEmpty() ? this.ancestors.get(0) : null;
    }

    boolean isValidParent(Tag child) {
        if (child.ancestors.isEmpty()) {
            return true;
        }
        for (Tag tag : child.ancestors) {
            if (!this.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag = (Tag)o;
        if (this.canContainBlock != tag.canContainBlock) {
            return false;
        }
        if (this.canContainInline != tag.canContainInline) {
            return false;
        }
        if (this.empty != tag.empty) {
            return false;
        }
        if (this.isBlock != tag.isBlock) {
            return false;
        }
        if (this.optionalClosing != tag.optionalClosing) {
            return false;
        }
        return !(this.tagName != null ? !this.tagName.equals(tag.tagName) : tag.tagName != null);
    }

    public int hashCode() {
        int result = this.tagName != null ? this.tagName.hashCode() : 0;
        result = 31 * result + (this.isBlock ? 1 : 0);
        result = 31 * result + (this.canContainBlock ? 1 : 0);
        result = 31 * result + (this.canContainInline ? 1 : 0);
        result = 31 * result + (this.optionalClosing ? 1 : 0);
        result = 31 * result + (this.empty ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.tagName;
    }

    private static Tag createBlock(String tagName) {
        return Tag.register(new Tag(tagName));
    }

    private static Tag createInline(String tagName) {
        Tag inline = new Tag(tagName);
        inline.isBlock = false;
        inline.canContainBlock = false;
        return Tag.register(inline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Tag register(Tag tag) {
        tag.setAncestor(Tag.defaultAncestor.tagName);
        Map<String, Tag> map = tags;
        synchronized (map) {
            tags.put(tag.tagName, tag);
        }
        return tag;
    }

    private Tag setContainInlineOnly() {
        this.canContainBlock = false;
        this.canContainInline = true;
        return this;
    }

    private Tag setContainDataOnly() {
        this.canContainBlock = false;
        this.canContainInline = false;
        this.preserveWhitespace = true;
        return this;
    }

    private Tag setEmpty() {
        this.canContainBlock = false;
        this.canContainInline = false;
        this.empty = true;
        return this;
    }

    private Tag setOptionalClosing() {
        this.optionalClosing = true;
        return this;
    }

    private Tag setPreserveWhitespace() {
        this.preserveWhitespace = true;
        return this;
    }

    private Tag setAncestor(String ... tagNames) {
        if (tagNames == null) {
            this.ancestors = Collections.emptyList();
        } else {
            this.ancestors = new ArrayList<Tag>(tagNames.length);
            for (String name : tagNames) {
                this.ancestors.add(Tag.valueOf(name));
            }
        }
        return this;
    }

    static {
        tags.put(Tag.defaultAncestor.tagName, defaultAncestor);
        Tag.createBlock("HTML").setAncestor(new String[0]);
        Tag.createBlock("HEAD").setAncestor("HTML");
        Tag.createBlock("BODY").setAncestor("HTML");
        Tag.createBlock("FRAMESET").setAncestor("HTML");
        Tag.createBlock("SCRIPT").setAncestor("HEAD", "BODY").setContainDataOnly();
        Tag.createBlock("NOSCRIPT").setAncestor("HEAD", "BODY");
        Tag.createBlock("STYLE").setAncestor("HEAD", "BODY").setContainDataOnly();
        Tag.createBlock("META").setAncestor("HEAD", "BODY").setEmpty();
        Tag.createBlock("LINK").setAncestor("HEAD", "BODY").setEmpty();
        Tag.createInline("OBJECT").setAncestor("HEAD", "BODY");
        Tag.createBlock("TITLE").setAncestor("HEAD", "BODY").setContainDataOnly();
        Tag.createInline("BASE").setAncestor("HEAD", "BODY").setEmpty();
        Tag.createBlock("FRAME").setAncestor("FRAMESET").setEmpty();
        Tag.createBlock("NOFRAMES").setAncestor("FRAMESET").setContainDataOnly();
        Tag.createInline("FONT");
        Tag.createInline("TT");
        Tag.createInline("I");
        Tag.createInline("B");
        Tag.createInline("BIG");
        Tag.createInline("SMALL");
        Tag.createInline("EM");
        Tag.createInline("STRONG");
        Tag.createInline("DFN");
        Tag.createInline("CODE");
        Tag.createInline("SAMP");
        Tag.createInline("KBD");
        Tag.createInline("VAR");
        Tag.createInline("CITE");
        Tag.createInline("ABBR");
        Tag.createInline("ACRONYM");
        Tag.createInline("A").setOptionalClosing();
        Tag.createInline("IMG").setEmpty();
        Tag.createInline("BR").setEmpty();
        Tag.createInline("MAP");
        Tag.createInline("Q");
        Tag.createInline("SUB");
        Tag.createInline("SUP");
        Tag.createInline("SPAN");
        Tag.createInline("BDO");
        Tag.createBlock("P").setContainInlineOnly();
        Tag.createBlock("H1").setContainInlineOnly();
        Tag.createBlock("H2").setContainInlineOnly();
        Tag.createBlock("H3").setContainInlineOnly();
        Tag.createBlock("H4").setContainInlineOnly();
        Tag.createBlock("H5").setContainInlineOnly();
        Tag.createBlock("H6").setContainInlineOnly();
        Tag.createBlock("UL");
        Tag.createBlock("OL");
        Tag.createBlock("PRE").setContainInlineOnly().setPreserveWhitespace();
        Tag.createBlock("DIV");
        Tag.createBlock("BLOCKQUOTE");
        Tag.createBlock("HR").setEmpty();
        Tag.createBlock("ADDRESS").setContainInlineOnly();
        Tag.createBlock("FORM").setOptionalClosing();
        Tag.createInline("INPUT").setAncestor("FORM").setEmpty();
        Tag.createInline("SELECT").setAncestor("FORM");
        Tag.createInline("TEXTAREA").setAncestor("FORM").setContainDataOnly();
        Tag.createInline("LABEL").setAncestor("FORM").setOptionalClosing();
        Tag.createInline("BUTTON").setAncestor("FORM");
        Tag.createInline("OPTGROUP").setAncestor("SELECT");
        Tag.createInline("OPTION").setAncestor("SELECT").setContainDataOnly();
        Tag.createBlock("FIELDSET").setAncestor("FORM");
        Tag.createInline("LEGEND").setAncestor("FIELDSET");
        Tag.createInline("AREA").setEmpty();
        Tag.createInline("PARAM").setAncestor("OBJECT").setEmpty();
        Tag.createBlock("INS");
        Tag.createBlock("DEL");
        Tag.createBlock("DL");
        Tag.createInline("DT").setAncestor("DL").setOptionalClosing();
        Tag.createInline("DD").setAncestor("DL").setOptionalClosing();
        Tag.createBlock("LI").setAncestor("UL", "OL").setOptionalClosing();
        Tag.createBlock("TABLE");
        Tag.createBlock("CAPTION").setAncestor("TABLE");
        Tag.createBlock("THEAD").setAncestor("TABLE").setOptionalClosing();
        Tag.createBlock("TFOOT").setAncestor("TABLE").setOptionalClosing();
        Tag.createBlock("TBODY").setAncestor("TABLE").setOptionalClosing();
        Tag.createBlock("COLGROUP").setAncestor("TABLE").setOptionalClosing();
        Tag.createBlock("COL").setAncestor("COLGROUP").setEmpty();
        Tag.createBlock("TR").setAncestor("TABLE").setOptionalClosing();
        Tag.createBlock("TH").setAncestor("TR").setOptionalClosing();
        Tag.createBlock("TD").setAncestor("TR").setOptionalClosing();
    }
}

