/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.LinkedList;
import org.apache.commons.lang.Validate;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Tag;
import org.jsoup.parser.TokenQueue;

public class Parser {
    private static final String SQ = "'";
    private static final String DQ = "\"";
    private static final Tag htmlTag = Tag.valueOf("html");
    private static final Tag headTag = Tag.valueOf("head");
    private static final Tag bodyTag = Tag.valueOf("body");
    private static final Tag titleTag = Tag.valueOf("title");
    private static final Tag textareaTag = Tag.valueOf("textarea");
    private final LinkedList<Element> stack;
    private final TokenQueue tq;
    private final Document doc;
    private String baseUri;

    private Parser(String html, String baseUri, boolean isBodyFragment) {
        Validate.notNull((Object)html);
        Validate.notNull((Object)baseUri);
        this.stack = new LinkedList();
        this.tq = new TokenQueue(html);
        this.baseUri = baseUri;
        if (isBodyFragment) {
            this.doc = Document.createShell(baseUri);
            this.stack.add(this.doc.body());
        } else {
            this.doc = new Document(baseUri);
            this.stack.add(this.doc);
        }
    }

    public static Document parse(String html, String baseUri) {
        Parser parser = new Parser(html, baseUri, false);
        return parser.parse();
    }

    public static Document parseBodyFragment(String bodyHtml, String baseUri) {
        Parser parser = new Parser(bodyHtml, baseUri, true);
        return parser.parse();
    }

    private Document parse() {
        while (!this.tq.isEmpty()) {
            if (this.tq.matches("<!--")) {
                this.parseComment();
                continue;
            }
            if (this.tq.matches("<![CDATA[")) {
                this.parseCdata();
                continue;
            }
            if (this.tq.matches("<?") || this.tq.matches("<!")) {
                this.parseXmlDecl();
                continue;
            }
            if (this.tq.matches("</")) {
                this.parseEndTag();
                continue;
            }
            if (this.tq.matches("<")) {
                this.parseStartTag();
                continue;
            }
            this.parseTextNode();
        }
        return this.doc.normalise();
    }

    private void parseComment() {
        this.tq.consume("<!--");
        String data = this.tq.chompTo("->");
        if (data.endsWith("-")) {
            data = data.substring(0, data.length() - 1);
        }
        Comment comment = new Comment(data, this.baseUri);
        this.last().appendChild(comment);
    }

    private void parseXmlDecl() {
        this.tq.consume("<");
        Character firstChar = this.tq.consume();
        boolean procInstr = firstChar.toString().equals("!");
        String data = this.tq.chompTo(">");
        XmlDeclaration decl = new XmlDeclaration(data, this.baseUri, procInstr);
        this.last().appendChild(decl);
    }

    private void parseEndTag() {
        this.tq.consume("</");
        String tagName = this.tq.consumeWord();
        this.tq.chompTo(">");
        if (tagName.length() != 0) {
            Tag tag = Tag.valueOf(tagName);
            this.popStackToClose(tag);
        }
    }

    private void parseStartTag() {
        String href;
        this.tq.consume("<");
        String tagName = this.tq.consumeWord();
        if (tagName.length() == 0) {
            this.tq.addFirst("&lt;");
            this.parseTextNode();
            return;
        }
        Attributes attributes = new Attributes();
        while (!this.tq.matchesAny("<", "/>", ">") && !this.tq.isEmpty()) {
            Attribute attribute = this.parseAttribute();
            if (attribute == null) continue;
            attributes.put(attribute);
        }
        Tag tag = Tag.valueOf(tagName);
        Element child = new Element(tag, this.baseUri, attributes);
        boolean isEmptyElement = tag.isEmpty();
        if (this.tq.matchChomp("/>")) {
            isEmptyElement = true;
        } else {
            this.tq.matchChomp(">");
        }
        if (tag.isData()) {
            String data = this.tq.chompTo("</" + tagName);
            this.tq.chompTo(">");
            Node dataNode = tag.equals(titleTag) || tag.equals(textareaTag) ? TextNode.createFromEncoded(data, this.baseUri) : new DataNode(data, this.baseUri);
            child.appendChild(dataNode);
        }
        if (child.tagName().equals("base") && (href = child.absUrl("href")).length() != 0) {
            this.baseUri = href;
            this.doc.setBaseUri(href);
        }
        this.addChildToParent(child, isEmptyElement);
    }

    private Attribute parseAttribute() {
        this.tq.consumeWhitespace();
        String key = this.tq.consumeAttributeKey();
        String value = "";
        this.tq.consumeWhitespace();
        if (this.tq.matchChomp("=")) {
            this.tq.consumeWhitespace();
            if (this.tq.matchChomp(SQ)) {
                value = this.tq.chompTo(SQ);
            } else if (this.tq.matchChomp(DQ)) {
                value = this.tq.chompTo(DQ);
            } else {
                StringBuilder valueAccum = new StringBuilder();
                while (!(this.tq.matchesAny("<", "/>", ">") || this.tq.matchesWhitespace() || this.tq.isEmpty())) {
                    valueAccum.append(this.tq.consume());
                }
                value = valueAccum.toString();
            }
            this.tq.consumeWhitespace();
        }
        if (key.length() != 0) {
            return Attribute.createFromEncoded(key, value);
        }
        this.tq.consume();
        return null;
    }

    private void parseTextNode() {
        String text = this.tq.consumeTo("<");
        TextNode textNode = TextNode.createFromEncoded(text, this.baseUri);
        this.last().appendChild(textNode);
    }

    private void parseCdata() {
        this.tq.consume("<![CDATA[");
        String rawText = this.tq.chompTo("]]>");
        TextNode textNode = new TextNode(rawText, this.baseUri);
        this.last().appendChild(textNode);
    }

    private Element addChildToParent(Element child, boolean isEmptyElement) {
        Element parent = this.popStackToSuitableContainer(child.tag());
        Tag childTag = child.tag();
        boolean validAncestor = this.stackHasValidParent(childTag);
        if (!validAncestor) {
            Tag parentTag = childTag.getImplicitParent();
            Element implicit = new Element(parentTag, this.baseUri);
            if (child.tag().equals(bodyTag)) {
                Element head = new Element(headTag, this.baseUri);
                implicit.appendChild(head);
            }
            implicit.appendChild(child);
            Element root = this.addChildToParent(implicit, false);
            if (!isEmptyElement) {
                this.stack.addLast(child);
            }
            return root;
        }
        parent.appendChild(child);
        if (!isEmptyElement) {
            this.stack.addLast(child);
        }
        return parent;
    }

    private boolean stackHasValidParent(Tag childTag) {
        if (this.stack.size() == 1 && childTag.equals(htmlTag)) {
            return true;
        }
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            Element el = this.stack.get(i);
            Tag parent2 = el.tag();
            if (!parent2.isValidParent(childTag)) continue;
            return true;
        }
        return false;
    }

    private Element popStackToSuitableContainer(Tag tag) {
        while (!this.stack.isEmpty()) {
            if (this.last().tag().canContain(tag)) {
                return this.last();
            }
            this.stack.removeLast();
        }
        return null;
    }

    private Element popStackToClose(Tag tag) {
        int i;
        int counter = 0;
        Element elToClose = null;
        for (i = this.stack.size() - 1; i > 0; --i) {
            ++counter;
            Element el = this.stack.get(i);
            Tag elTag = el.tag();
            if (elTag.equals(bodyTag) || elTag.equals(htmlTag)) break;
            if (!elTag.equals(tag)) continue;
            elToClose = el;
            break;
        }
        if (elToClose != null) {
            for (i = 0; i < counter; ++i) {
                this.stack.removeLast();
            }
        }
        return elToClose;
    }

    private Element last() {
        return this.stack.getLast();
    }
}

