/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;

public class TextNode
extends Node {
    private static final String TEXT_KEY = "text";

    public TextNode(String text, String baseUri) {
        super(baseUri);
        this.attributes.put(TEXT_KEY, text);
    }

    public String nodeName() {
        return "#text";
    }

    public String text() {
        return this.outerHtml();
    }

    public TextNode text(String text) {
        this.attributes.put(TEXT_KEY, text);
        return this;
    }

    public String getWholeText() {
        return this.attributes.get(TEXT_KEY);
    }

    public boolean isBlank() {
        return StringUtils.isBlank((String)TextNode.normaliseWhitespace(this.getWholeText()));
    }

    void outerHtml(StringBuilder accum) {
        String html = StringEscapeUtils.escapeHtml((String)this.getWholeText());
        if (this.parent() instanceof Element && !((Element)this.parent()).preserveWhitespace()) {
            html = TextNode.normaliseWhitespace(html);
        }
        if (!this.isBlank() && this.parentNode instanceof Element && ((Element)this.parentNode).tag().canContainBlock() && this.siblingIndex() == 0) {
            this.indent(accum);
        }
        accum.append(html);
    }

    public String toString() {
        return this.outerHtml();
    }

    public static TextNode createFromEncoded(String encodedText, String baseUri) {
        String text = StringEscapeUtils.unescapeHtml((String)encodedText);
        return new TextNode(text, baseUri);
    }

    static String normaliseWhitespace(String text) {
        text = text.replaceAll("\\s{2,}|(\\r\\n|\\r|\\n)", " ");
        return text;
    }

    static String stripLeadingWhitespace(String text) {
        return text.replaceFirst("^\\s+", "");
    }

    static boolean lastCharIsWhitespace(StringBuilder sb) {
        if (sb.length() == 0) {
            return false;
        }
        String lastChar = sb.substring(sb.length() - 1, sb.length());
        Validate.isTrue((lastChar.length() == 1 ? 1 : 0) != 0);
        return lastChar.equals(" ");
    }
}

