/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jsoup.nodes.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node {
    Node parentNode;
    final List<Node> childNodes;
    final Attributes attributes;
    String baseUri;

    protected Node(String baseUri, Attributes attributes) {
        Validate.notNull((Object)baseUri);
        Validate.notNull((Object)attributes);
        this.childNodes = new ArrayList<Node>();
        this.baseUri = baseUri.trim();
        this.attributes = attributes;
    }

    protected Node(String baseUri) {
        this(baseUri, new Attributes());
    }

    public abstract String nodeName();

    public String attr(String attributeKey) {
        Validate.notNull((Object)attributeKey);
        if (this.hasAttr(attributeKey)) {
            return this.attributes.get(attributeKey);
        }
        if (attributeKey.toLowerCase().startsWith("abs:")) {
            return this.absUrl(attributeKey.substring("abs:".length()));
        }
        return "";
    }

    public Attributes attributes() {
        return this.attributes;
    }

    public Node attr(String attributeKey, String attributeValue) {
        this.attributes.put(attributeKey, attributeValue);
        return this;
    }

    public boolean hasAttr(String attributeKey) {
        Validate.notNull((Object)attributeKey);
        return this.attributes.hasKey(attributeKey);
    }

    public Node removeAttr(String attributeKey) {
        Validate.notNull((Object)attributeKey);
        this.attributes.remove(attributeKey);
        return this;
    }

    public String baseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        Validate.notNull((Object)baseUri);
        this.baseUri = baseUri;
    }

    public String absUrl(String attributeKey) {
        Validate.notEmpty((String)attributeKey);
        String relUrl = this.attr(attributeKey);
        if (!this.hasAttr(attributeKey)) {
            return "";
        }
        try {
            URL base;
            try {
                base = new URL(this.baseUri);
            }
            catch (MalformedURLException e) {
                URL abs = new URL(relUrl);
                return abs.toExternalForm();
            }
            URL abs = new URL(base, relUrl);
            return abs.toExternalForm();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public Node childNode(int index) {
        return this.childNodes.get(index);
    }

    public List<Node> childNodes() {
        return Collections.unmodifiableList(this.childNodes);
    }

    public Node parent() {
        return this.parentNode;
    }

    public void remove() {
        Validate.notNull((Object)this.parentNode);
        this.parentNode.removeChild(this);
    }

    public void replaceWith(Node in) {
        Validate.notNull((Object)in);
        Validate.notNull((Object)this.parentNode);
        this.parentNode.replaceChild(this, in);
    }

    protected void setParentNode(Node parentNode) {
        if (this.parentNode != null) {
            throw new NotImplementedException("Cannot (yet) move nodes in tree");
        }
        this.parentNode = parentNode;
    }

    protected void replaceChild(Node out, Node in) {
        Validate.isTrue((out.parentNode == this ? 1 : 0) != 0);
        Validate.notNull((Object)in);
        if (in.parentNode != null) {
            in.parentNode.removeChild(in);
        }
        Integer index = Node.indexInList(out, this.childNodes);
        this.childNodes.set(index, in);
        in.parentNode = this;
        out.parentNode = null;
    }

    protected void removeChild(Node out) {
        Validate.isTrue((out.parentNode == this ? 1 : 0) != 0);
        int index = Node.indexInList(out, this.childNodes);
        this.childNodes.remove(index);
        out.parentNode = null;
    }

    protected void addChild(Node in) {
        Validate.notNull((Object)in);
        if (in.parentNode != null) {
            in.parentNode.removeChild(in);
        }
        this.childNodes.add(in);
        in.parentNode = this;
    }

    protected int nodeDepth() {
        if (this.parentNode == null) {
            return 0;
        }
        return this.parentNode.nodeDepth() + 1;
    }

    public List<Node> siblingNodes() {
        return this.parent().childNodes();
    }

    public Node nextSibling() {
        List<Node> siblings = this.parentNode.childNodes;
        Integer index = Node.indexInList(this, siblings);
        Validate.notNull((Object)index);
        if (siblings.size() > index + 1) {
            return siblings.get(index + 1);
        }
        return null;
    }

    public Node previousSibling() {
        List<Node> siblings = this.parentNode.childNodes;
        Integer index = Node.indexInList(this, siblings);
        Validate.notNull((Object)index);
        if (index > 0) {
            return siblings.get(index - 1);
        }
        return null;
    }

    public Integer siblingIndex() {
        return Node.indexInList(this, this.parent().childNodes);
    }

    protected static <N extends Node> Integer indexInList(N search, List<N> nodes) {
        Validate.notNull(search);
        Validate.notNull(nodes);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = (Node)nodes.get(i);
            if (!node.equals(search)) continue;
            return i;
        }
        return null;
    }

    public String outerHtml() {
        StringBuilder accum = new StringBuilder();
        this.outerHtml(accum);
        return accum.toString();
    }

    abstract void outerHtml(StringBuilder var1);

    public String toString() {
        return this.outerHtml();
    }

    protected void indent(StringBuilder accum) {
        accum.append("\n").append(StringUtils.leftPad((String)"", (int)(this.nodeDepth() - 2)));
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = this.parentNode != null ? this.parentNode.hashCode() : 0;
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }
}

