/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Evaluator;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element
extends Node {
    private final Tag tag;
    private Set<String> classNames;

    public Element(Tag tag, String baseUri, Attributes attributes) {
        super(baseUri, attributes);
        Validate.notNull((Object)tag);
        this.tag = tag;
    }

    public Element(Tag tag, String baseUri) {
        this(tag, baseUri, new Attributes());
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        String id = this.attr("id");
        return id == null ? "" : id;
    }

    @Override
    public Element attr(String attributeKey, String attributeValue) {
        super.attr(attributeKey, attributeValue);
        return this;
    }

    @Override
    public Element parent() {
        return (Element)super.parent();
    }

    public Element child(int index) {
        return this.children().get(index);
    }

    public Elements children() {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node node : this.childNodes) {
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        return new Elements((List<Element>)elements);
    }

    public Elements select(String query) {
        return Selector.select(query, this);
    }

    public Element appendChild(Node child) {
        Validate.notNull((Object)child);
        child.setParentNode(this);
        this.childNodes.add(child);
        return this;
    }

    public Element prependChild(Node child) {
        Validate.notNull((Object)child);
        child.setParentNode(this);
        this.childNodes.add(0, child);
        return this;
    }

    public Element appendElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.appendChild(child);
        return child;
    }

    public Element prependElement(String tagName) {
        Element child = new Element(Tag.valueOf(tagName), this.baseUri());
        this.prependChild(child);
        return child;
    }

    public Element appendText(String text) {
        TextNode node = new TextNode(text, this.baseUri());
        this.appendChild(node);
        return this;
    }

    public Element prependText(String text) {
        TextNode node = new TextNode(text, this.baseUri());
        this.prependChild(node);
        return this;
    }

    public Element append(String html) {
        Validate.notNull((Object)html);
        Element fragment = Parser.parseBodyFragment(html, this.baseUri).body();
        for (Node node : fragment.childNodes()) {
            node.parentNode = null;
            this.appendChild(node);
        }
        return this;
    }

    public Element prepend(String html) {
        Validate.notNull((Object)html);
        Element fragment = Parser.parseBodyFragment(html, this.baseUri).body();
        List<Node> nodes = fragment.childNodes();
        for (int i = nodes.size() - 1; i >= 0; --i) {
            Node node = nodes.get(i);
            node.parentNode = null;
            this.prependChild(node);
        }
        return this;
    }

    public Element empty() {
        this.childNodes.clear();
        return this;
    }

    public Element wrap(String html) {
        Validate.notEmpty((String)html);
        Element wrapBody = Parser.parseBodyFragment(html, this.baseUri).body();
        Elements wrapChildren = wrapBody.children();
        Element wrap = wrapChildren.first();
        if (wrap == null) {
            return null;
        }
        Element deepest = this.getDeepChild(wrap);
        this.parentNode.replaceChild(this, wrap);
        deepest.addChild(this);
        if (wrapChildren.size() > 1) {
            for (int i = 1; i < wrapChildren.size(); ++i) {
                Element remainder = wrapChildren.get(i);
                remainder.parentNode.removeChild(remainder);
                wrap.appendChild(remainder);
            }
        }
        return this;
    }

    private Element getDeepChild(Element el) {
        Elements children = el.children();
        if (children.size() > 0) {
            return this.getDeepChild((Element)children.get(0));
        }
        return el;
    }

    public Elements siblingElements() {
        return this.parent().children();
    }

    public Element nextElementSibling() {
        Elements siblings = this.parent().children();
        Integer index = Element.indexInList(this, siblings);
        Validate.notNull((Object)index);
        if (siblings.size() > index + 1) {
            return (Element)siblings.get(index + 1);
        }
        return null;
    }

    public Element previousElementSibling() {
        Elements siblings = this.parent().children();
        Integer index = Element.indexInList(this, siblings);
        Validate.notNull((Object)index);
        if (index > 0) {
            return (Element)siblings.get(index - 1);
        }
        return null;
    }

    public Element firstElementSibling() {
        Elements siblings = this.parent().children();
        return siblings.size() > 1 ? (Element)siblings.get(0) : null;
    }

    public Integer elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        return Element.indexInList(this, this.parent().children());
    }

    public Element lastElementSibling() {
        Elements siblings = this.parent().children();
        return siblings.size() > 1 ? (Element)siblings.get(siblings.size() - 1) : null;
    }

    public Elements getElementsByTag(String tagName) {
        Validate.notEmpty((String)tagName);
        tagName = tagName.toLowerCase().trim();
        return Collector.collect(new Evaluator.Tag(tagName), this);
    }

    public Element getElementById(String id) {
        Validate.notEmpty((String)id);
        Elements elements = Collector.collect(new Evaluator.Id(id), this);
        if (elements.size() > 0) {
            return elements.get(0);
        }
        return null;
    }

    public Elements getElementsByClass(String className) {
        Validate.notEmpty((String)className);
        return Collector.collect(new Evaluator.Class(className), this);
    }

    public Elements getElementsByAttribute(String key) {
        Validate.notEmpty((String)key);
        key = key.trim().toLowerCase();
        return Collector.collect(new Evaluator.Attribute(key), this);
    }

    public Elements getElementsByAttributeValue(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValue(key, value), this);
    }

    public Elements getElementsByAttributeValueNot(String key, String value) {
        return Collector.collect(new Evaluator.AttributeWithValueNot(key, value), this);
    }

    public Elements getElementsByAttributeValueStarting(String key, String valuePrefix) {
        return Collector.collect(new Evaluator.AttributeWithValueStarting(key, valuePrefix), this);
    }

    public Elements getElementsByAttributeValueEnding(String key, String valueSuffix) {
        return Collector.collect(new Evaluator.AttributeWithValueEnding(key, valueSuffix), this);
    }

    public Elements getElementsByAttributeValueContaining(String key, String match) {
        return Collector.collect(new Evaluator.AttributeWithValueContaining(key, match), this);
    }

    public Elements getElementsByIndexLessThan(int index) {
        return Collector.collect(new Evaluator.IndexLessThan(index), this);
    }

    public Elements getElementsByIndexGreaterThan(int index) {
        return Collector.collect(new Evaluator.IndexGreaterThan(index), this);
    }

    public Elements getElementsByIndexEquals(int index) {
        return Collector.collect(new Evaluator.IndexEquals(index), this);
    }

    public Elements getAllElements() {
        return Collector.collect(new Evaluator.AllElements(), this);
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        this.text(sb);
        return sb.toString().trim();
    }

    private void text(StringBuilder accum) {
        for (Node child : this.childNodes) {
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                String text = textNode.getWholeText();
                if (!this.preserveWhitespace()) {
                    text = TextNode.normaliseWhitespace(text);
                    if (TextNode.lastCharIsWhitespace(accum)) {
                        text = TextNode.stripLeadingWhitespace(text);
                    }
                }
                accum.append(text);
                continue;
            }
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            if (accum.length() > 0 && element.isBlock() && !TextNode.lastCharIsWhitespace(accum)) {
                accum.append(" ");
            }
            element.text(accum);
        }
    }

    boolean preserveWhitespace() {
        return this.tag.preserveWhitespace() || this.parent() != null && this.parent().preserveWhitespace();
    }

    public Element text(String text) {
        Validate.notNull((Object)text);
        this.empty();
        TextNode textNode = new TextNode(text, this.baseUri);
        this.appendChild(textNode);
        return this;
    }

    public boolean hasText() {
        for (Node child : this.childNodes) {
            Element el;
            TextNode textNode;
            if (!(child instanceof TextNode ? !(textNode = (TextNode)child).isBlank() : child instanceof Element && (el = (Element)child).hasText())) continue;
            return true;
        }
        return false;
    }

    public String data() {
        StringBuilder sb = new StringBuilder();
        for (Node childNode : this.childNodes) {
            if (childNode instanceof DataNode) {
                DataNode data = (DataNode)childNode;
                sb.append(data.getWholeData());
                continue;
            }
            if (!(childNode instanceof Element)) continue;
            Element element = (Element)childNode;
            String elementData = element.data();
            sb.append(elementData);
        }
        return sb.toString();
    }

    public String className() {
        return this.attributes.hasKey("class") ? this.attributes.get("class") : "";
    }

    public Set<String> classNames() {
        if (this.classNames == null) {
            String[] names = this.className().split("\\s+");
            this.classNames = new LinkedHashSet<String>(Arrays.asList(names));
        }
        return this.classNames;
    }

    public Element classNames(Set<String> classNames) {
        Validate.notNull(classNames);
        this.attributes.put("class", StringUtils.join(classNames, (String)" "));
        return this;
    }

    public boolean hasClass(String className) {
        return this.classNames().contains(className);
    }

    public Element addClass(String className) {
        Validate.notNull((Object)className);
        Set<String> classes = this.classNames();
        classes.add(className);
        this.classNames(classes);
        return this;
    }

    public Element removeClass(String className) {
        Validate.notNull((Object)className);
        Set<String> classes = this.classNames();
        classes.remove(className);
        this.classNames(classes);
        return this;
    }

    public Element toggleClass(String className) {
        Validate.notNull((Object)className);
        Set<String> classes = this.classNames();
        if (classes.contains(className)) {
            classes.remove(className);
        } else {
            classes.add(className);
        }
        this.classNames(classes);
        return this;
    }

    public String val() {
        if (this.tagName().equals("textarea")) {
            return this.text();
        }
        return this.attr("value");
    }

    public Element val(String value) {
        if (this.tagName().equals("textarea")) {
            this.text(value);
        } else {
            this.attr("value", value);
        }
        return this;
    }

    @Override
    void outerHtml(StringBuilder accum) {
        if (this.isBlock() || this.parent() != null && this.parent().tag().canContainBlock() && this.siblingIndex() == 0) {
            this.indent(accum);
        }
        accum.append("<").append(this.tagName()).append(this.attributes.html());
        if (this.childNodes.isEmpty() && this.tag.isEmpty()) {
            accum.append(" />");
        } else {
            accum.append(">");
            this.html(accum);
            if (this.tag.canContainBlock()) {
                this.indent(accum);
            }
            accum.append("</").append(this.tagName()).append(">");
        }
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        this.html(accum);
        return accum.toString().trim();
    }

    private void html(StringBuilder accum) {
        for (Node node : this.childNodes) {
            node.outerHtml(accum);
        }
    }

    public Element html(String html) {
        this.empty();
        this.append(html);
        return this;
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Element element = (Element)o;
        return !(this.tag != null ? !this.tag.equals(element.tag) : element.tag != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
        return result;
    }
}

