/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;

public class Document
extends Element {
    public Document(String baseUri) {
        super(Tag.valueOf("#root"), baseUri);
    }

    public static Document createShell(String baseUri) {
        Validate.notNull((Object)baseUri);
        Document doc = new Document(baseUri);
        Element html = doc.appendElement("html");
        html.appendElement("head");
        html.appendElement("body");
        return doc;
    }

    public Element head() {
        return this.getElementsByTag("head").first();
    }

    public Element body() {
        return this.getElementsByTag("body").first();
    }

    public String title() {
        Element titleEl = this.getElementsByTag("title").first();
        return titleEl != null ? titleEl.text().trim() : "";
    }

    public void title(String title) {
        Validate.notNull((Object)title);
        Element titleEl = this.getElementsByTag("title").first();
        if (titleEl == null) {
            this.head().appendElement("title").text(title);
        } else {
            titleEl.text(title);
        }
    }

    public Element createElement(String tagName) {
        return new Element(Tag.valueOf(tagName), this.baseUri());
    }

    public Document normalise() {
        if (this.select("html").isEmpty()) {
            this.appendElement("html");
        }
        if (this.head() == null) {
            this.select("html").first().prependElement("head");
        }
        if (this.body() == null) {
            this.select("html").first().appendElement("body");
        }
        this.normalise(this);
        this.normalise(this.select("html").first());
        this.normalise(this.head());
        return this;
    }

    private void normalise(Element element) {
        ArrayList<TextNode> toMove = new ArrayList<TextNode>();
        for (Node node : element.childNodes) {
            TextNode tn;
            if (!(node instanceof TextNode) || (tn = (TextNode)node).isBlank()) continue;
            toMove.add(tn);
        }
        for (Node node : toMove) {
            element.removeChild(node);
            this.body().appendChild(new TextNode(" ", ""));
            this.body().appendChild(node);
        }
    }

    public String outerHtml() {
        return super.html();
    }

    public Element text(String text) {
        this.body().text(text);
        return this;
    }

    public String nodeName() {
        return "#document";
    }
}

