/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.apache.commons.lang.StringEscapeUtils;
import org.jsoup.nodes.Node;

public class DataNode
extends Node {
    private static final String DATA_KEY = "data";

    public DataNode(String data, String baseUri) {
        super(baseUri);
        this.attributes.put(DATA_KEY, data);
    }

    public String nodeName() {
        return "#data";
    }

    public String getWholeData() {
        return this.attributes.get(DATA_KEY);
    }

    void outerHtml(StringBuilder accum) {
        accum.append(this.getWholeData());
    }

    public String toString() {
        return this.outerHtml();
    }

    public static DataNode createFromEncoded(String encodedData, String baseUri) {
        String data = StringEscapeUtils.unescapeHtml((String)encodedData);
        return new DataNode(data, baseUri);
    }
}

