/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jsoup.nodes.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attributes
implements Iterable<Attribute> {
    private LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();

    public String get(String key) {
        Validate.notEmpty((String)key);
        Attribute attr = this.attributes.get(key.toLowerCase());
        return attr != null ? attr.getValue() : "";
    }

    public void put(String key, String value) {
        Attribute attr = new Attribute(key, value);
        this.put(attr);
    }

    public void put(Attribute attribute) {
        Validate.notNull((Object)attribute);
        this.attributes.put(attribute.getKey(), attribute);
    }

    public void remove(String key) {
        Validate.notEmpty((String)key);
        this.attributes.remove(key.toLowerCase());
    }

    public boolean hasKey(String key) {
        return this.attributes.containsKey(key.toLowerCase());
    }

    public int size() {
        return this.attributes.size();
    }

    public void addAll(Attributes incoming) {
        this.attributes.putAll(incoming.attributes);
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.asList().iterator();
    }

    public List<Attribute> asList() {
        ArrayList<Attribute> list = new ArrayList<Attribute>(this.attributes.size());
        for (Map.Entry<String, Attribute> entry : this.attributes.entrySet()) {
            list.add(entry.getValue());
        }
        return Collections.unmodifiableList(list);
    }

    public String html() {
        StringBuilder accum = new StringBuilder();
        for (Attribute attribute : this) {
            accum.append(" ");
            accum.append(attribute.html());
        }
        return accum.toString();
    }

    public String toString() {
        return this.html();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attributes)) {
            return false;
        }
        Attributes that = (Attributes)o;
        return !(this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null);
    }

    public int hashCode() {
        return this.attributes != null ? this.attributes.hashCode() : 0;
    }
}

