/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.Validate;

public class Attribute {
    private String key;
    private String value;

    public Attribute(String key, String value) {
        Validate.notEmpty((String)key);
        Validate.notNull((Object)value);
        this.key = key.trim().toLowerCase();
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        Validate.notEmpty((String)key);
        this.key = key.trim().toLowerCase();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        Validate.notNull((Object)value);
        this.value = value;
    }

    public String html() {
        return String.format("%s=\"%s\"", this.key, StringEscapeUtils.escapeHtml((String)this.value));
    }

    public String toString() {
        return this.html();
    }

    public static Attribute createFromEncoded(String unencodedKey, String encodedValue) {
        String value = StringEscapeUtils.unescapeHtml((String)encodedValue);
        return new Attribute(unencodedKey, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(attribute.value) : attribute.value != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

