/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang.Validate;

class DataUtil {
    DataUtil() {
    }

    static String load(File in, String charsetName) throws IOException {
        FileInputStream inStream = new FileInputStream(in);
        String data = DataUtil.readInputStream(inStream, charsetName);
        ((InputStream)inStream).close();
        return data;
    }

    static String load(URL url, int timeoutMillis) throws IOException {
        String protocol = url.getProtocol();
        Validate.isTrue((protocol.equals("http") || protocol.equals("https") ? 1 : 0) != 0, (String)"Only http & https protocols supported");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setConnectTimeout(timeoutMillis);
        conn.setReadTimeout(timeoutMillis);
        conn.connect();
        int res = conn.getResponseCode();
        if (res != 200) {
            throw new IOException(res + " error loading URL " + url.toString());
        }
        String contentType = conn.getContentType();
        if (contentType == null || !contentType.startsWith("text/")) {
            throw new IOException(String.format("Unhandled content type \"%s\" on URL %s. Must be text/*", contentType, url.toString()));
        }
        BufferedInputStream inStream = new BufferedInputStream(conn.getInputStream());
        String charSet = "UTF-8";
        String data = DataUtil.readInputStream(inStream, charSet);
        ((InputStream)inStream).close();
        return data;
    }

    private static String readInputStream(InputStream inStream, String charsetName) throws IOException {
        int read;
        char[] buffer = new char[131072];
        StringBuilder data = new StringBuilder(131072);
        InputStreamReader inReader = new InputStreamReader(inStream, charsetName);
        do {
            if ((read = ((Reader)inReader).read(buffer, 0, buffer.length)) <= 0) continue;
            data.append(buffer, 0, read);
        } while (read >= 0);
        return data.toString();
    }
}

