/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.extras.common.util;

import com.atlassian.extras.api.Product;
import com.atlassian.extras.common.DateEditor;
import com.atlassian.extras.common.LicensePropertiesConstants;
import com.atlassian.extras.common.util.LicenseProperties;
import java.util.Date;
import java.util.Properties;

public class ProductLicenseProperties
implements LicenseProperties {
    private final Product product;
    private final Properties properties;

    public ProductLicenseProperties(Product product, Properties properties) {
        this.product = product;
        if (product == null) {
            throw new IllegalArgumentException("Product must NOT be null!");
        }
        if (properties == null) {
            throw new IllegalArgumentException("Properties must NOT be null!");
        }
        this.properties = properties;
    }

    public String getProperty(String s) {
        return this.getProperty(s, null);
    }

    public String getProperty(String s, String defaultValue) {
        String o = this.properties.getProperty(LicensePropertiesConstants.getKey(this.product, s));
        return o != null ? o : this.properties.getProperty(s, defaultValue);
    }

    public int getInt(String propertyName, int defaultValue) {
        String stringValue = this.getProperty(propertyName);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Date getDate(String key, Date defaultValue) {
        String stringValue = this.getProperty(key);
        if (stringValue == null || stringValue.length() == 0) {
            return defaultValue;
        }
        return DateEditor.getDate(stringValue);
    }
}

