/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNLookPropListCommand
extends SVNLookCommand {
    protected SVNLookPropListCommand() {
        super("proplist", new String[]{"plist", "pl"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        options.add(SVNLookOption.VERBOSE);
        options.add(SVNLookOption.REVPROP);
        options.add(SVNLookOption.XML);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        if (!environment.isRevProp() && environment.getFirstArgument() == null) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS, (String)"Missing repository path argument");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        SVNLookClient client = environment.getClientManager().getLookClient();
        SVNProperties props = null;
        props = environment.isRevision() ? (environment.isRevProp() ? client.doGetRevisionProperties(environment.getRepositoryFile(), this.getRevisionObject()) : client.doGetProperties(environment.getRepositoryFile(), environment.getFirstArgument(), this.getRevisionObject())) : (environment.isRevProp() ? client.doGetRevisionProperties(environment.getRepositoryFile(), environment.getTransaction()) : client.doGetProperties(environment.getRepositoryFile(), environment.getFirstArgument(), environment.getTransaction()));
        if (props != null) {
            for (String propName : props.nameSet()) {
                SVNPropertyData propData = new SVNPropertyData(propName, props.getSVNPropertyValue(propName), client.getOptions());
                SVNPropertyValue propValue = propData.getValue();
                if (environment.isVerbose()) {
                    environment.getOut().print("  " + propName + " : ");
                    if (propValue.isString()) {
                        environment.getOut().println(propValue.getString());
                        continue;
                    }
                    environment.getOut().println(SVNPropertyValue.getPropertyAsString((SVNPropertyValue)propValue));
                    continue;
                }
                environment.getOut().println("  " + propName);
            }
        }
    }
}

