/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnlook;

import java.util.Collection;
import java.util.LinkedList;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.wc.admin.ISVNChangeEntryHandler;
import org.tmatesoft.svn.core.wc.admin.SVNChangeEntry;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookChangedCommand
extends SVNLookCommand
implements ISVNChangeEntryHandler {
    public SVNLookChangedCommand() {
        super("changed", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        options.add(SVNLookOption.COPY_INFO);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        SVNLookClient client = environment.getClientManager().getLookClient();
        if (environment.isRevision()) {
            client.doGetChanged(environment.getRepositoryFile(), this.getRevisionObject(), (ISVNChangeEntryHandler)this, environment.isCopyInfo());
        } else {
            client.doGetChanged(environment.getRepositoryFile(), environment.getTransaction(), (ISVNChangeEntryHandler)this, environment.isCopyInfo());
        }
    }

    public void handleEntry(SVNChangeEntry entry) throws SVNException {
        String[] status = new String[]{entry.getType() == 'U' && !entry.hasTextModifications() ? "_" : "" + entry.getType(), entry.hasPropertyModifications() ? "U" : " ", entry.getCopyFromPath() != null ? "+" : " "};
        String path = !entry.getPath().endsWith("/") && entry.getKind() == SVNNodeKind.DIR ? entry.getPath() + "/" : entry.getPath();
        path = path.startsWith("/") ? path.substring(1) : path;
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        environment.getOut().println(status[0] + status[1] + status[2] + " " + path);
        if (entry.getCopyFromPath() != null) {
            String copyFromPath = entry.getCopyFromPath();
            if (copyFromPath.startsWith("/")) {
                copyFromPath = copyFromPath.substring(1);
            }
            if (!copyFromPath.endsWith("/") && entry.getKind() == SVNNodeKind.DIR) {
                copyFromPath = copyFromPath + "/";
            }
            environment.getOut().println("    (from " + copyFromPath + ":r" + entry.getCopyFromRevision() + ")");
        }
    }
}

