/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svnadmin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.cli.svnadmin.SVNAdminCommand;
import org.tmatesoft.svn.core.ISVNCanceller;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class SVNAdminRemoveLocksCommand
extends SVNAdminCommand
implements ISVNLockHandler {
    public SVNAdminRemoveLocksCommand() {
        super("rmlocks", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        return new ArrayList();
    }

    @Override
    public void run() throws SVNException {
        List<String> targets = this.getEnvironment().combineTargets(null, false);
        if (!targets.isEmpty()) {
            targets.remove(0);
        }
        String[] locks = targets.toArray(new String[targets.size()]);
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.fromFile((File)this.getLocalRepository()));
        String userName = System.getProperty("user.name", "administrator");
        repository.setAuthenticationManager((ISVNAuthenticationManager)new BasicAuthenticationManager(userName, ""));
        repository.setCanceller((ISVNCanceller)this.getEnvironment());
        for (int i = 0; i < locks.length; ++i) {
            String lockPath = locks[i];
            try {
                SVNLock lock = repository.getLock(lockPath);
                if (lock == null) {
                    this.getEnvironment().getOut().println("Path '" + lockPath + "' isn't locked.");
                    continue;
                }
                SVNHashMap pathToToken = new SVNHashMap();
                pathToToken.put(lockPath, lock.getID());
                repository.unlock((Map)pathToToken, true, (ISVNLockHandler)this);
                continue;
            }
            catch (SVNException e) {
                this.getEnvironment().handleError(e.getErrorMessage());
            }
        }
    }

    public void handleLock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
    }

    public void handleUnlock(String path, SVNLock lock, SVNErrorMessage error) throws SVNException {
        if (error != null) {
            this.getEnvironment().handleError(error);
        } else {
            this.getEnvironment().getOut().println("Removed lock on '" + path + "'.");
        }
    }
}

