/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNConflictAcceptPolicy;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNResolveCommand
extends SVNCommand {
    public SVNResolveCommand() {
        super("resolve", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.ACCEPT);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        SVNErrorMessage err;
        SVNConflictAcceptPolicy accept = this.getSVNEnvironment().getResolveAccept();
        SVNConflictChoice choice = null;
        if (accept == SVNConflictAcceptPolicy.WORKING) {
            choice = SVNConflictChoice.MERGED;
        } else if (accept == SVNConflictAcceptPolicy.BASE) {
            choice = SVNConflictChoice.BASE;
        } else if (accept == SVNConflictAcceptPolicy.THEIRS_CONFLICT) {
            choice = SVNConflictChoice.THEIRS_CONFLICT;
        } else if (accept == SVNConflictAcceptPolicy.MINE_CONFLICT) {
            choice = SVNConflictChoice.MINE_CONFLICT;
        } else if (accept == SVNConflictAcceptPolicy.MINE_FULL) {
            choice = SVNConflictChoice.MINE_FULL;
        } else if (accept == SVNConflictAcceptPolicy.THEIRS_FULL) {
            choice = SVNConflictChoice.THEIRS_FULL;
        } else if (accept == null || accept == SVNConflictAcceptPolicy.UNSPECIFIED) {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"missing --accept option");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        } else {
            err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"invalid 'accept' ARG");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler((ISVNEventHandler)new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.EMPTY;
        }
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (!target.isFile()) continue;
            try {
                client.doResolve(target.getFile(), depth, choice);
            }
            catch (SVNException e) {
                SVNErrorMessage err2 = e.getErrorMessage();
                this.getSVNEnvironment().handleWarning(err2, new SVNErrorCode[]{err2.getErrorCode()}, this.getSVNEnvironment().isQuiet());
            }
        }
    }
}

