/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNXMLCommand;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.ISVNAnnotateHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNBlameCommand
extends SVNXMLCommand
implements ISVNAnnotateHandler {
    private StringBuffer myBuffer;
    private int myCurrentLineNumber = 0;

    public SVNBlameCommand() {
        super("blame", new String[]{"praise", "annotate", "ann"});
    }

    @Override
    public boolean acceptsRevisionRange() {
        return true;
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.VERBOSE);
        options.add(SVNOption.USE_MERGE_HISTORY);
        options.add(SVNOption.INCREMENTAL);
        options.add(SVNOption.XML);
        options.add(SVNOption.EXTENSIONS);
        options.add(SVNOption.FORCE);
        return options;
    }

    @Override
    public void run() throws SVNException {
        List<String> targets = this.getSVNEnvironment().combineTargets(null, true);
        if (targets.isEmpty()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_INSUFFICIENT_ARGS), (SVNLogType)SVNLogType.CLIENT);
        }
        SVNRevision start = this.getSVNEnvironment().getStartRevision();
        SVNRevision end = this.getSVNEnvironment().getEndRevision();
        if (end == SVNRevision.UNDEFINED && start != SVNRevision.UNDEFINED) {
            end = start;
            start = SVNRevision.create((long)1L);
        }
        if (start == SVNRevision.UNDEFINED) {
            start = SVNRevision.create((long)1L);
        }
        if (this.getSVNEnvironment().isXML()) {
            if (this.getSVNEnvironment().isVerbose()) {
                SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'verbose' option invalid in XML mode"), (SVNLogType)SVNLogType.CLIENT);
            }
            if (!this.getSVNEnvironment().isIncremental()) {
                this.printXMLHeader("blame");
            }
        } else if (this.getSVNEnvironment().isIncremental()) {
            SVNErrorManager.error((SVNErrorMessage)SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CL_ARG_PARSING_ERROR, (String)"'incremental' option only valid in XML mode"), (SVNLogType)SVNLogType.CLIENT);
        }
        this.myBuffer = new StringBuffer();
        SVNLogClient client = this.getSVNEnvironment().getClientManager().getLogClient();
        client.setDiffOptions(this.getSVNEnvironment().getDiffOptions());
        boolean hasMissingTargets = false;
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName, true);
            SVNRevision endRev = end;
            if (endRev == SVNRevision.UNDEFINED && target.getPegRevision() != SVNRevision.UNDEFINED) {
                endRev = target.getPegRevision();
            }
            if (this.getSVNEnvironment().isXML()) {
                this.myBuffer = this.openXMLTag("target", 1, "path", SVNCommandUtil.getLocalPath(target.getTarget()), this.myBuffer);
            }
            try {
                if (target.isFile()) {
                    client.doAnnotate(target.getFile(), target.getPegRevision(), start, endRev, this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isUseMergeHistory(), (ISVNAnnotateHandler)this, null);
                } else {
                    client.doAnnotate(target.getURL(), target.getPegRevision(), start, endRev, this.getSVNEnvironment().isForce(), this.getSVNEnvironment().isUseMergeHistory(), (ISVNAnnotateHandler)this, null);
                }
                if (this.getSVNEnvironment().isXML()) {
                    this.myBuffer = this.closeXMLTag("target", this.myBuffer);
                    this.getSVNEnvironment().getOut().print(this.myBuffer);
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_IS_BINARY_FILE) {
                    this.getSVNEnvironment().getErr().println("Skipping binary file: '" + SVNCommandUtil.getLocalPath(targetName) + "'");
                }
                this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.WC_PATH_NOT_FOUND, SVNErrorCode.FS_NOT_FILE, SVNErrorCode.FS_NOT_FOUND, SVNErrorCode.ENTRY_NOT_FOUND}, this.getSVNEnvironment().isQuiet());
                hasMissingTargets = true;
            }
            this.myBuffer = this.myBuffer.delete(0, this.myBuffer.length());
        }
        if (this.getSVNEnvironment().isXML() && !this.getSVNEnvironment().isIncremental()) {
            this.printXMLFooter("blame");
        }
        if (hasMissingTargets) {
            SVNErrorMessage err = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.ILLEGAL_TARGET, (String)"Could not perform blame on all targets because some targets don't exist");
            SVNErrorManager.error((SVNErrorMessage)err, (SVNLogType)SVNLogType.CLIENT);
        }
    }

    public void handleLine(Date date, long revision, String author, String line) throws SVNException {
        ++this.myCurrentLineNumber;
        this.handleLine(date, revision, author, line, null, -1L, null, null, this.myCurrentLineNumber);
    }

    public void handleLine(Date date, long revision, String author, String line, Date mergedDate, long mergedRevision, String mergedAuthor, String mergedPath, int lineNumber) throws SVNException {
        if (this.getSVNEnvironment().isXML()) {
            this.myBuffer = this.openXMLTag("entry", 1, "line-number", Long.toString(lineNumber + 1), this.myBuffer);
            if (SVNRevision.isValidRevisionNumber((long)revision)) {
                this.myBuffer = this.openXMLTag("commit", 1, "revision", Long.toString(revision), this.myBuffer);
                this.myBuffer = this.openCDataTag("author", author, this.myBuffer);
                this.myBuffer = this.openCDataTag("date", ((SVNDate)date).format(), this.myBuffer);
                this.myBuffer = this.closeXMLTag("commit", this.myBuffer);
            }
            if (this.getSVNEnvironment().isUseMergeHistory() && SVNRevision.isValidRevisionNumber((long)mergedRevision)) {
                this.myBuffer = this.openXMLTag("merged", 1, "path", mergedPath, this.myBuffer);
                this.myBuffer = this.openXMLTag("commit", 1, "revision", Long.toString(mergedRevision), this.myBuffer);
                this.myBuffer = this.openCDataTag("author", mergedAuthor, this.myBuffer);
                this.myBuffer = this.openCDataTag("date", ((SVNDate)mergedDate).format(), this.myBuffer);
                this.myBuffer = this.closeXMLTag("commit", this.myBuffer);
                this.myBuffer = this.closeXMLTag("merged", this.myBuffer);
            }
            this.myBuffer = this.closeXMLTag("entry", this.myBuffer);
        } else {
            String authorStr;
            String mergedStr = "";
            if (this.getSVNEnvironment().isUseMergeHistory()) {
                if (revision > mergedRevision) {
                    mergedStr = "G ";
                    date = mergedDate;
                    revision = mergedRevision;
                    author = mergedAuthor;
                } else {
                    mergedStr = "  ";
                }
            }
            String revStr = revision >= 0L ? SVNFormatUtil.formatString((String)Long.toString(revision), (int)6, (boolean)false) : "     -";
            String string = authorStr = author != null ? SVNFormatUtil.formatString((String)author, (int)10, (boolean)false) : "         -";
            if (this.getSVNEnvironment().isVerbose()) {
                String dateStr = "                                           -";
                if (date != null) {
                    dateStr = SVNDate.formatHumanDate((Date)date, (ISVNOptions)this.getSVNEnvironment().getClientManager().getOptions());
                }
                this.getSVNEnvironment().getOut().print(mergedStr + revStr + " " + authorStr + " " + dateStr + " ");
                if (this.getSVNEnvironment().isUseMergeHistory() && mergedPath != null) {
                    String pathStr = SVNFormatUtil.formatString((String)mergedPath, (int)14, (boolean)true);
                    this.getSVNEnvironment().getOut().print(pathStr + " ");
                }
                this.getSVNEnvironment().getOut().println(line);
            } else {
                this.getSVNEnvironment().getOut().println(mergedStr + revStr + " " + authorStr + " " + line);
            }
        }
    }

    public boolean handleRevision(Date date, long revision, String author, File contents) throws SVNException {
        return false;
    }

    public void handleEOF() {
    }
}

