/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringObfuscator;
import com.atlassian.utils.process.StringOutputHandler;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingProcessMonitor
implements ProcessMonitor {
    private Logger logger;
    private Priority priority;
    private StringObfuscator obfuscator;

    public LoggingProcessMonitor(Logger logger, Priority priority) {
        this.logger = logger;
        this.priority = priority;
    }

    public LoggingProcessMonitor(Logger logger, Priority priority, StringObfuscator obfuscator) {
        this(logger, priority);
        this.obfuscator = obfuscator;
    }

    protected String obfuscate(String value) {
        if (this.obfuscator != null) {
            return this.obfuscator.obfuscate(value);
        }
        return value;
    }

    protected String getCommandLine(ExternalProcess process) {
        return this.obfuscate(process.getCommandLine());
    }

    @Override
    public void onBeforeStart(ExternalProcess process) {
        if (this.logger != null && this.logger.isEnabledFor(this.priority)) {
            this.logger.log(this.priority, (Object)("Starting process: " + this.getCommandLine(process)));
        }
    }

    @Override
    public void onAfterFinished(ExternalProcess process) {
        if (this.logger != null && this.logger.isEnabledFor(this.priority)) {
            StringBuilder message = new StringBuilder();
            String commandLine = this.getCommandLine(process);
            message.append("Finished process: ").append(commandLine);
            Long startTime = process.getStartTime();
            if (startTime != null) {
                message.append(" took ").append(System.currentTimeMillis() - startTime).append("ms");
            }
            this.logger.log(this.priority, (Object)message.toString());
            ProcessHandler handler = process.getHandler();
            if (handler != null && !handler.succeeded()) {
                this.logger.info((Object)this.getErrorMessage(process));
            }
        }
    }

    public String getErrorMessage(ExternalProcess process) {
        StringOutputHandler errorStringHandler;
        OutputHandler errorHandler;
        ProcessHandler handler = process.getHandler();
        String commandLine = this.getCommandLine(process);
        StringBuilder message = new StringBuilder();
        if (handler.getException() != null) {
            message.append("Exception executing command \"").append(commandLine).append("\" ").append(handler.getException().getMessage()).append("\n").append(handler.getException()).append("\n");
        }
        String reason = null;
        if (handler instanceof PluggableProcessHandler && (errorHandler = ((PluggableProcessHandler)handler).getErrorHandler()) instanceof StringOutputHandler && (errorStringHandler = (StringOutputHandler)errorHandler).getOutput() != null) {
            reason = errorStringHandler.getOutput();
        }
        if (reason != null && reason.trim().length() > 0) {
            message.append("Error executing command \"").append(commandLine).append("\": ").append(reason);
        }
        return this.obfuscate(message.toString());
    }
}

