/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.UserType;

public class EmptyStringUserType
implements Serializable,
UserType {
    private static final String EMPTY_STRING = "";
    private static final int[] TYPES = new int[]{12};

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public Serializable disassemble(Object value) {
        return (Serializable)this.deepCopy(value);
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        String dbValue = (String)StandardBasicTypes.STRING.nullSafeGet(rs, names[0], session);
        if (dbValue != null) {
            return dbValue;
        }
        return EMPTY_STRING;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        StandardBasicTypes.STRING.nullSafeSet(st, value, index, session);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Class returnedClass() {
        return String.class;
    }

    public int[] sqlTypes() {
        return TYPES;
    }
}

