/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras.dialect.resolver;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SQLServer2005Dialect;
import org.hibernate.dialect.SQLServer2008Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.service.jdbc.dialect.internal.AbstractDialectResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerDialectResolver
extends AbstractDialectResolver {
    private static final Logger log = LoggerFactory.getLogger(SqlServerDialectResolver.class);

    public Dialect resolveDialectInternal(DatabaseMetaData metaData) throws SQLException {
        String databaseName = metaData.getDatabaseProductName();
        if (databaseName.startsWith("Microsoft SQL Server")) {
            int databaseMajorVersion = metaData.getDatabaseMajorVersion();
            switch (databaseMajorVersion) {
                case 8: {
                    return this.createSqlServer2000Dialect(databaseName, databaseMajorVersion);
                }
                case 9: {
                    return this.createSqlServer2005Dialect(databaseName, databaseMajorVersion);
                }
                case 10: {
                    return this.createSqlServer2008Dialect(databaseName, databaseMajorVersion);
                }
                case 11: {
                    return this.createSqlServer2012Dialect(databaseName, databaseMajorVersion);
                }
            }
        }
        log.trace("No dialect is known for {}; deferring to standard dialect resolver", (Object)databaseName);
        return null;
    }

    protected Dialect createSqlServer2000Dialect(String databaseName, int databaseMajorVersion) {
        log.debug("Returning SQL Server 2000 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion);
        return new SQLServerDialect();
    }

    protected Dialect createSqlServer2005Dialect(String databaseName, int databaseMajorVersion) {
        log.debug("Returning SQL Server 2005 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion);
        return new SQLServer2005Dialect();
    }

    protected Dialect createSqlServer2008Dialect(String databaseName, int databaseMajorVersion) {
        log.debug("Returning SQL Server 2008 dialect for {} (Version: {})", (Object)databaseName, (Object)databaseMajorVersion);
        return new SQLServer2008Dialect();
    }

    protected Dialect createSqlServer2012Dialect(String databaseName, int databaseMajorVersion) {
        return this.createSqlServer2008Dialect(databaseName, databaseMajorVersion);
    }
}

