/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.TableGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettableTableHiLoGenerator
extends TableGenerator {
    public static final String MAX_LO = "max_lo";
    private static final Logger log = LoggerFactory.getLogger(ResettableTableHiLoGenerator.class);
    private long hi;
    private int lo;
    private int maxLo;
    private Class<?> returnClass;

    public void configure(Type type, Properties params, Dialect d) {
        super.configure(type, params, d);
        this.maxLo = ConfigurationHelper.getInt((String)MAX_LO, (Map)params, (int)Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SessionImplementor session, Object obj) throws HibernateException {
        if (this.lo > this.maxLo) {
            long hival = ((Number)super.generate(session, obj)).longValue();
            this.lo = 1;
            this.hi = hival * (long)(this.maxLo + 1);
            log.debug("new hi value: " + hival);
        }
        return ResettableTableHiLoGenerator.createNumber(this.hi + (long)this.lo++, this.returnClass);
    }

    public synchronized void reset() {
        this.lo = this.maxLo + 1;
    }

    public String[] sqlCreateStrings(Dialect dialect) {
        String[] createTableStatements = super.sqlCreateStrings(dialect);
        for (int i = 0; i < createTableStatements.length; ++i) {
            String createTableStatement = createTableStatements[i];
            if (!createTableStatement.startsWith(dialect.getCreateTableString())) continue;
            createTableStatements[i] = createTableStatement + dialect.getTableTypeString();
            break;
        }
        return createTableStatements;
    }

    private static Number createNumber(long value, Class<?> clazz) throws IdentifierGenerationException {
        if (clazz == Long.class) {
            return value;
        }
        if (clazz == Integer.class) {
            return (int)value;
        }
        if (clazz == Short.class) {
            return (short)value;
        }
        throw new IdentifierGenerationException("This ID generator generates long, integer, short");
    }

    public int getMaxLo() {
        return this.maxLo;
    }
}

