/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras;

import com.atlassian.hibernate.extras.ResettableTableHiLoGenerator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.AbstractWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.support.JdbcUtils;

public class ResetableHiLoGeneratorHelper {
    public static final String HIBERNATE_UNIQUE_KEY_COLUMN = "next_hi";
    public static final String HIBERNATE_UNIQUE_KEY_TABLE = "hibernate_unique_key";
    private static final Logger log = LoggerFactory.getLogger(ResetableHiLoGeneratorHelper.class);
    private SessionFactory sessionFactory;

    public long getHiValue() throws SQLException {
        Session session = this.sessionFactory.getCurrentSession();
        try {
            return (Long)((SessionImplementor)session).getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new NextHiGetter(), true);
        }
        catch (JDBCException e) {
            log.error("Error finding maximum next_hi value", (Throwable)e.getSQLException());
            throw e.getSQLException();
        }
    }

    public void setNextHiValue(List<String> errors) {
        Session session = this.sessionFactory.getCurrentSession();
        ((SessionImplementor)session).getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork((WorkExecutorVisitable)new NextHiSetter(errors, this.sessionFactory), true);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private static class NextHiSetter
    extends AbstractWork {
        private final List<String> errors;
        private final SessionFactoryImplementor sessionFactory;

        private NextHiSetter(List<String> errors, SessionFactory sessionFactory) {
            this.errors = errors;
            this.sessionFactory = (SessionFactoryImplementor)sessionFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Connection connection) {
            Map metadataMap = this.sessionFactory.getAllClassMetadata();
            Statement statement = null;
            try {
                statement = connection.createStatement();
                long maximumId = 0L;
                int maxLo = 0;
                for (String className : metadataMap.keySet()) {
                    EntityPersister persister = this.sessionFactory.getEntityPersister(className);
                    if (!(persister instanceof SingleTableEntityPersister) || !(persister.getIdentifierGenerator() instanceof ResettableTableHiLoGenerator)) continue;
                    SingleTableEntityPersister entityPersister = (SingleTableEntityPersister)persister;
                    ResettableTableHiLoGenerator generator = (ResettableTableHiLoGenerator)persister.getIdentifierGenerator();
                    if (maxLo == 0) {
                        maxLo = generator.getMaxLo();
                    } else if (maxLo != generator.getMaxLo()) {
                        this.errors.add("One generator uses " + maxLo + " for maxLo, generator for " + className + " uses " + generator.getMaxLo());
                    }
                    String[] idColumnNames = entityPersister.getIdentifierColumnNames();
                    if (idColumnNames.length != 1) {
                        this.errors.add("Expected a single ID column for " + className + " found " + idColumnNames.length);
                    }
                    String sql = "select max(" + idColumnNames[0] + ") from " + entityPersister.getTableName();
                    ResultSet resultSet = null;
                    try {
                        resultSet = statement.executeQuery(sql);
                        if (resultSet.next()) {
                            long value = resultSet.getLong(1);
                            if (value <= maximumId) continue;
                            maximumId = value;
                            continue;
                        }
                        this.errors.add("No maximum ID returned for " + className);
                    }
                    finally {
                        JdbcUtils.closeResultSet((ResultSet)resultSet);
                    }
                }
                this.setNextHi(statement, (int)(maximumId / (long)(maxLo + 1)) + 1);
            }
            catch (Exception e) {
                log.error("Error finding maximum next_hi value", (Throwable)e);
                this.errors.add(e.getMessage());
            }
            finally {
                JdbcUtils.closeStatement((Statement)statement);
                log.info("Completed database update: HiLoIdRepairUpgradeTask");
            }
        }

        private void setNextHi(Statement statement, int nextHi) throws SQLException {
            log.info("Setting new next_hi to " + nextHi);
            if (statement.executeUpdate("update hibernate_unique_key set next_hi = " + nextHi) == 0 && statement.executeUpdate("insert into hibernate_unique_key values(" + nextHi + ")") == 0) {
                this.errors.add("failed to insert initial next_hi value");
            }
        }
    }

    private static class NextHiGetter
    extends AbstractReturningWork<Long> {
        private static final String SQL = "select next_hi from hibernate_unique_key";

        private NextHiGetter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long execute(Connection connection) throws SQLException {
            Statement statement;
            ResultSet resultSet;
            block2: {
                Long l;
                resultSet = null;
                statement = null;
                try {
                    statement = connection.createStatement();
                    resultSet = statement.executeQuery(SQL);
                    if (!resultSet.next()) break block2;
                    l = resultSet.getLong(1);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(resultSet);
                    JdbcUtils.closeStatement((Statement)statement);
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)resultSet);
                JdbcUtils.closeStatement((Statement)statement);
                return l;
            }
            JdbcUtils.closeResultSet((ResultSet)resultSet);
            JdbcUtils.closeStatement((Statement)statement);
            return 0L;
        }
    }
}

