/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.model;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.descriptors.WebPanelRendererModuleDescriptor;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.web.renderer.RendererException;
import com.atlassian.plugin.web.renderer.StaticWebPanelRenderer;
import com.atlassian.plugin.web.renderer.WebPanelRenderer;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class AbstractWebPanel
implements WebPanel {
    private final PluginAccessor pluginAccessor;
    protected Plugin plugin;
    private String resourceType;

    protected AbstractWebPanel(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = (String)Preconditions.checkNotNull((Object)resourceType);
    }

    public void writeHtml(Writer writer, Map<String, Object> context) throws IOException {
        writer.write(this.getHtml(context));
    }

    protected final WebPanelRenderer getRenderer() {
        if ("static".equals(this.resourceType)) {
            return StaticWebPanelRenderer.RENDERER;
        }
        try {
            return ((WebPanelRendererModuleDescriptor)((Object)Iterables.find((Iterable)this.pluginAccessor.getEnabledModuleDescriptorsByClass(WebPanelRendererModuleDescriptor.class), (Predicate)new Predicate<WebPanelRendererModuleDescriptor>(){

                public boolean apply(WebPanelRendererModuleDescriptor descriptor) {
                    WebPanelRenderer webPanelRenderer = descriptor.getModule();
                    return ((String)Preconditions.checkNotNull((Object)AbstractWebPanel.this.resourceType)).equals(webPanelRenderer.getResourceType());
                }
            }))).getModule();
        }
        catch (NoSuchElementException e) {
            throw new RendererException("No renderer found for resource type: " + this.resourceType, e);
        }
    }
}

