/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz1;

import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.CronScheduleInfo;
import com.atlassian.scheduler.config.IntervalScheduleInfo;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.spi.SchedulerServiceConfiguration;
import com.atlassian.scheduler.core.util.CronExpressionQuantizer;
import com.atlassian.scheduler.core.util.ParameterMapSerializer;
import com.atlassian.scheduler.core.util.QuartzParseExceptionMapper;
import com.atlassian.scheduler.core.util.TimeIntervalQuantizer;
import com.atlassian.scheduler.cron.CronSyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

class Quartz1TriggerFactory {
    private final SchedulerServiceConfiguration config;
    private final ParameterMapSerializer parameterMapSerializer;

    Quartz1TriggerFactory(SchedulerServiceConfiguration config, ParameterMapSerializer parameterMapSerializer) {
        this.config = config;
        this.parameterMapSerializer = parameterMapSerializer;
    }

    public Trigger buildTrigger(JobId jobId, JobConfig jobConfig) throws SchedulerServiceException {
        byte[] parameters = this.parameterMapSerializer.serializeParameters(jobConfig.getParameters());
        Trigger trigger = this.buildTrigger(jobConfig.getSchedule());
        trigger.setGroup("SchedulerServiceTriggers");
        trigger.setName(jobId.toString());
        trigger.getJobDataMap().put((Object)"parameters", (Object)parameters);
        return trigger;
    }

    public Trigger buildTrigger(Schedule schedule) throws SchedulerServiceException {
        switch (schedule.getType()) {
            case INTERVAL: {
                return Quartz1TriggerFactory.getSimpleTrigger(schedule.getIntervalScheduleInfo());
            }
            case CRON_EXPRESSION: {
                return this.getCronTrigger(schedule.getCronScheduleInfo());
            }
        }
        throw new IllegalStateException("type=" + schedule.getType());
    }

    private static Trigger getSimpleTrigger(IntervalScheduleInfo info) {
        Date startTime = info.getFirstRunTime() != null ? info.getFirstRunTime() : new Date();
        SimpleTrigger trigger = new SimpleTrigger();
        trigger.setStartTime(startTime);
        if (info.getIntervalInMillis() == 0L) {
            trigger.setRepeatCount(0);
        } else {
            trigger.setRepeatCount(-1);
            trigger.setRepeatInterval(TimeIntervalQuantizer.quantizeToMinutes((long)info.getIntervalInMillis()));
        }
        return trigger;
    }

    private Trigger getCronTrigger(CronScheduleInfo info) throws CronSyntaxException {
        try {
            CronTrigger trigger = new CronTrigger();
            trigger.setCronExpression(CronExpressionQuantizer.quantizeSecondsField((String)info.getCronExpression()));
            trigger.setTimeZone(this.getTimeZone(info));
            return trigger;
        }
        catch (ParseException pe) {
            throw QuartzParseExceptionMapper.mapException((String)info.getCronExpression().toUpperCase(Locale.US), (ParseException)pe);
        }
    }

    @Nonnull
    private TimeZone getTimeZone(CronScheduleInfo info) {
        TimeZone timeZone = info.getTimeZone();
        if (timeZone == null && (timeZone = this.config.getDefaultTimeZone()) == null) {
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }
}

