/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz1;

import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.core.spi.SchedulerServiceConfiguration;
import com.atlassian.scheduler.quartz1.Quartz1JobDetailsFactory;
import com.atlassian.scheduler.quartz1.Quartz1SchedulerFacade;
import com.atlassian.scheduler.quartz1.Quartz1TriggerFactory;
import com.atlassian.scheduler.quartz1.spi.Quartz1SchedulerConfiguration;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.tenancy.api.TenantAccessor;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quartz1SchedulerService
extends AbstractSchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(Quartz1SchedulerService.class);
    private final Quartz1SchedulerFacade localJobs;
    private final Quartz1SchedulerFacade clusteredJobs;
    private final Quartz1TriggerFactory triggerFactory;
    private final Quartz1JobDetailsFactory jobDetailsFactory;

    public Quartz1SchedulerService(RunDetailsDao runDetailsDao, Quartz1SchedulerConfiguration config, TenantAccessor tenantAccessor) throws SchedulerServiceException {
        super(runDetailsDao, tenantAccessor);
        this.localJobs = Quartz1SchedulerFacade.createLocal((AbstractSchedulerService)this, config);
        this.clusteredJobs = Quartz1SchedulerFacade.createClustered((AbstractSchedulerService)this, config);
        this.triggerFactory = new Quartz1TriggerFactory(config, this.getParameterMapSerializer());
        this.jobDetailsFactory = new Quartz1JobDetailsFactory(this);
    }

    public Quartz1SchedulerService(RunDetailsDao runDetailsDao, SchedulerServiceConfiguration config, Scheduler localScheduler, Scheduler clusteredScheduler, TenantAccessor tenantAccessor) throws SchedulerServiceException {
        super(runDetailsDao, tenantAccessor);
        this.localJobs = Quartz1SchedulerFacade.createLocal((AbstractSchedulerService)this, localScheduler);
        this.clusteredJobs = Quartz1SchedulerFacade.createClustered((AbstractSchedulerService)this, clusteredScheduler);
        this.triggerFactory = new Quartz1TriggerFactory(config, this.getParameterMapSerializer());
        this.jobDetailsFactory = new Quartz1JobDetailsFactory(this);
    }

    protected void doScheduleJob(JobId jobId, JobConfig jobConfig) throws SchedulerServiceException {
        try {
            Assertions.notNull((String)"jobConfig", (Object)jobConfig);
            LOG.debug("scheduleJob: {}: {}", (Object)jobId, (Object)jobConfig);
            this.localJobs.unscheduleJob(jobId);
            this.clusteredJobs.unscheduleJob(jobId);
            Quartz1SchedulerFacade facade = this.getFacade(jobConfig.getRunMode());
            JobRunnerKey jobRunnerKey = jobConfig.getJobRunnerKey();
            Trigger trigger = this.triggerFactory.buildTrigger(jobId, jobConfig);
            facade.scheduleJob(jobRunnerKey, trigger);
        }
        catch (SchedulerRuntimeException sre) {
            throw Quartz1SchedulerService.checked((SchedulerRuntimeException)sre);
        }
    }

    public void unscheduleJob(JobId jobId) {
        boolean found = this.localJobs.unscheduleJob(jobId);
        if (found |= this.clusteredJobs.unscheduleJob(jobId)) {
            LOG.debug("unscheduleJob: {}", (Object)jobId);
        } else {
            LOG.debug("unscheduleJob for non-existent jobId: {}", (Object)jobId);
        }
    }

    @Nullable
    public Date calculateNextRunTime(Schedule schedule) throws SchedulerServiceException {
        Trigger trigger = this.triggerFactory.buildTrigger(schedule);
        return trigger.getFireTimeAfter(new Date());
    }

    @Nullable
    public JobDetails getJobDetails(JobId jobId) {
        JobDetails jobDetails = this.getJobDetails(this.clusteredJobs, jobId, RunMode.RUN_ONCE_PER_CLUSTER);
        if (jobDetails == null) {
            jobDetails = this.getJobDetails(this.localJobs, jobId, RunMode.RUN_LOCALLY);
        }
        return jobDetails;
    }

    @Nullable
    private JobDetails getJobDetails(Quartz1SchedulerFacade facade, JobId jobId, RunMode runMode) {
        Trigger trigger = facade.getTrigger(jobId);
        return trigger != null ? this.jobDetailsFactory.buildJobDetails(jobId, trigger, runMode) : null;
    }

    @Nonnull
    public Set<JobRunnerKey> getJobRunnerKeysForAllScheduledJobs() {
        HashSet<JobRunnerKey> jobRunnerKeys = new HashSet<JobRunnerKey>(this.localJobs.getJobRunnerKeys());
        jobRunnerKeys.addAll(this.clusteredJobs.getJobRunnerKeys());
        return ImmutableSet.copyOf(jobRunnerKeys);
    }

    @Nonnull
    public List<JobDetails> getJobsByJobRunnerKey(JobRunnerKey jobRunnerKey) {
        UniqueJobDetailsCollector collector = new UniqueJobDetailsCollector();
        collector.collect(RunMode.RUN_ONCE_PER_CLUSTER, this.clusteredJobs.getTriggersOfJob(jobRunnerKey));
        collector.collect(RunMode.RUN_LOCALLY, this.localJobs.getTriggersOfJob(jobRunnerKey));
        return collector.getResults();
    }

    @Deprecated
    public Scheduler getLocalQuartzScheduler() {
        return this.localJobs.getQuartz();
    }

    @Deprecated
    public Scheduler getClusteredQuartzScheduler() {
        return this.clusteredJobs.getQuartz();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startImpl() throws SchedulerServiceException {
        boolean abort = true;
        this.localJobs.start();
        try {
            this.clusteredJobs.start();
            abort = false;
        }
        finally {
            if (abort) {
                this.localJobs.standby();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void standbyImpl() throws SchedulerServiceException {
        try {
            this.localJobs.standby();
        }
        finally {
            this.clusteredJobs.standby();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownImpl() {
        try {
            this.localJobs.shutdown();
        }
        finally {
            this.clusteredJobs.shutdown();
        }
    }

    private Quartz1SchedulerFacade getFacade(RunMode runMode) {
        switch (runMode) {
            case RUN_LOCALLY: {
                return this.localJobs;
            }
            case RUN_ONCE_PER_CLUSTER: {
                return this.clusteredJobs;
            }
        }
        throw new IllegalArgumentException("runMode=" + runMode);
    }

    class UniqueJobDetailsCollector {
        final Set<String> jobIdsSeen = Sets.newHashSet();
        final List<JobDetails> jobs = Lists.newArrayList();

        UniqueJobDetailsCollector() {
        }

        void collect(RunMode runMode, Trigger[] triggers) {
            for (Trigger trigger : triggers) {
                String jobId = trigger.getName();
                if (!this.jobIdsSeen.add(jobId)) continue;
                try {
                    this.jobs.add(Quartz1SchedulerService.this.jobDetailsFactory.buildJobDetails(JobId.of((String)jobId), trigger, runMode));
                }
                catch (SchedulerRuntimeException sre) {
                    LOG.debug("Unable to reconstruct log details for jobId '{}'", (Object)jobId, (Object)sre);
                }
            }
        }

        List<JobDetails> getResults() {
            Collections.sort(this.jobs, BY_JOB_ID);
            return ImmutableList.copyOf(this.jobs);
        }
    }
}

