/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz1;

import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.quartz1.Quartz1Job;
import com.atlassian.scheduler.quartz1.Quartz1JobFactory;
import com.atlassian.scheduler.quartz1.spi.Quartz1SchedulerConfiguration;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.annotation.Nullable;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Quartz1SchedulerFacade {
    private static final Logger LOG = LoggerFactory.getLogger(Quartz1SchedulerFacade.class);
    static final String QUARTZ_JOB_GROUP = "SchedulerServiceJobs";
    static final String QUARTZ_TRIGGER_GROUP = "SchedulerServiceTriggers";
    static final String QUARTZ_PARAMETERS_KEY = "parameters";
    private final Supplier<Scheduler> quartzRef;

    private Quartz1SchedulerFacade(Supplier<Scheduler> quartzRef) {
        this.quartzRef = quartzRef;
    }

    static Quartz1SchedulerFacade createLocal(AbstractSchedulerService schedulerService, Scheduler scheduler) throws SchedulerServiceException {
        Assertions.notNull((String)"scheduler", (Object)scheduler);
        return Quartz1SchedulerFacade.createFacade(schedulerService, scheduler, RunMode.RUN_LOCALLY);
    }

    static Quartz1SchedulerFacade createClustered(AbstractSchedulerService schedulerService, Scheduler scheduler) throws SchedulerServiceException {
        Assertions.notNull((String)"scheduler", (Object)scheduler);
        return Quartz1SchedulerFacade.createFacade(schedulerService, scheduler, RunMode.RUN_ONCE_PER_CLUSTER);
    }

    private static Quartz1SchedulerFacade createFacade(AbstractSchedulerService schedulerService, Scheduler scheduler, RunMode runMode) throws SchedulerServiceException {
        try {
            Quartz1SchedulerFacade.configureScheduler(scheduler, schedulerService, runMode);
            Supplier quartzRef = Suppliers.ofInstance((Object)scheduler);
            return new Quartz1SchedulerFacade((Supplier<Scheduler>)quartzRef);
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.checked("Unable to configure the underlying Quartz scheduler", se);
        }
    }

    static Quartz1SchedulerFacade createLocal(AbstractSchedulerService schedulerService, Quartz1SchedulerConfiguration config) throws SchedulerServiceException {
        Assertions.notNull((String)"config", (Object)config);
        Properties localSettings = (Properties)Assertions.notNull((String)"config.getLocalSettings()", (Object)config.getLocalSettings());
        return Quartz1SchedulerFacade.createFacade(schedulerService, localSettings, RunMode.RUN_LOCALLY);
    }

    static Quartz1SchedulerFacade createClustered(AbstractSchedulerService schedulerService, Quartz1SchedulerConfiguration config) throws SchedulerServiceException {
        Assertions.notNull((String)"config", (Object)config);
        Properties clusteredSettings = (Properties)Assertions.notNull((String)"config.getClusteredSettings()", (Object)config.getClusteredSettings());
        return Quartz1SchedulerFacade.createFacade(schedulerService, clusteredSettings, RunMode.RUN_ONCE_PER_CLUSTER);
    }

    private static Quartz1SchedulerFacade createFacade(AbstractSchedulerService schedulerService, Properties customConfig, RunMode runMode) throws SchedulerServiceException {
        try {
            Properties config = new Properties();
            for (String key : customConfig.stringPropertyNames()) {
                config.setProperty(key, customConfig.getProperty(key));
            }
            config.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(config);
            Supplier<Scheduler> quartzRef = Quartz1SchedulerFacade.createQuartzRef(schedulerService, runMode, schedulerFactory);
            return new Quartz1SchedulerFacade(quartzRef);
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.checked("Unable to create the underlying Quartz scheduler", se);
        }
    }

    private static Supplier<Scheduler> createQuartzRef(final AbstractSchedulerService schedulerService, final RunMode runMode, final StdSchedulerFactory schedulerFactory) {
        return new LazyReference<Scheduler>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Scheduler create() throws Exception {
                Thread thd = Thread.currentThread();
                ClassLoader originalContextClassLoader = thd.getContextClassLoader();
                try {
                    thd.setContextClassLoader(schedulerService.getClass().getClassLoader());
                    Scheduler quartz = schedulerFactory.getScheduler();
                    Quartz1SchedulerFacade.configureScheduler(quartz, schedulerService, runMode);
                    Scheduler scheduler = quartz;
                    return scheduler;
                }
                finally {
                    thd.setContextClassLoader(originalContextClassLoader);
                }
            }
        };
    }

    static void configureScheduler(Scheduler quartz, AbstractSchedulerService schedulerService, RunMode runMode) throws SchedulerException {
        quartz.setJobFactory((JobFactory)new Quartz1JobFactory(schedulerService, runMode));
    }

    @Nullable
    Trigger getTrigger(JobId jobId) {
        try {
            return this.getScheduler().getTrigger(jobId.toString(), QUARTZ_TRIGGER_GROUP);
        }
        catch (SchedulerException se) {
            Quartz1SchedulerFacade.logWarn("Error getting quartz trigger for '{}'", jobId, se);
            return null;
        }
    }

    @Nullable
    JobDetail getQuartzJob(JobRunnerKey jobRunnerKey) {
        try {
            return this.getScheduler().getJobDetail(jobRunnerKey.toString(), QUARTZ_JOB_GROUP);
        }
        catch (SchedulerException se) {
            Quartz1SchedulerFacade.logWarn("Error getting quartz job details for '{}'", jobRunnerKey, se);
            return null;
        }
    }

    boolean hasAnyTriggers(JobRunnerKey jobRunnerKey) {
        return this.getTriggersOfJob(jobRunnerKey).length > 0;
    }

    Collection<JobRunnerKey> getJobRunnerKeys() {
        try {
            return Lists.transform(Arrays.asList(this.getScheduler().getJobNames(QUARTZ_JOB_GROUP)), (Function)new Function<String, JobRunnerKey>(){

                public JobRunnerKey apply(String jobName) {
                    return JobRunnerKey.of((String)jobName);
                }
            });
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.unchecked("Could not get the triggers from Quartz", se);
        }
    }

    Trigger[] getTriggersOfJob(JobRunnerKey jobRunnerKey) {
        try {
            return this.getScheduler().getTriggersOfJob(jobRunnerKey.toString(), QUARTZ_JOB_GROUP);
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.unchecked("Could not get the triggers from Quartz", se);
        }
    }

    boolean deleteTrigger(JobId jobId) {
        try {
            return this.getScheduler().unscheduleJob(jobId.toString(), QUARTZ_TRIGGER_GROUP);
        }
        catch (SchedulerException se) {
            Quartz1SchedulerFacade.logWarn("Error removing Quartz trigger for '{}'", jobId, se);
            return false;
        }
    }

    boolean deleteJob(JobRunnerKey jobRunnerKey) {
        try {
            return this.getScheduler().deleteJob(jobRunnerKey.toString(), QUARTZ_JOB_GROUP);
        }
        catch (SchedulerException se) {
            Quartz1SchedulerFacade.logWarn("Error removing Quartz job for '{}'", jobRunnerKey, se);
            return false;
        }
    }

    private void scheduleJob(Trigger trigger) throws SchedulerServiceException {
        try {
            this.getScheduler().scheduleJob(trigger);
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.checked("Unable to create the Quartz trigger", se);
        }
    }

    void scheduleJob(JobRunnerKey jobRunnerKey, Trigger trigger) throws SchedulerServiceException {
        if (this.getQuartzJob(jobRunnerKey) != null) {
            trigger.setJobGroup(QUARTZ_JOB_GROUP);
            trigger.setJobName(jobRunnerKey.toString());
            this.scheduleJob(trigger);
            return;
        }
        try {
            JobDetail quartzJob = new JobDetail();
            quartzJob.setGroup(QUARTZ_JOB_GROUP);
            quartzJob.setName(jobRunnerKey.toString());
            quartzJob.setJobClass(Quartz1Job.class);
            quartzJob.setDurability(false);
            this.getScheduler().scheduleJob(quartzJob, trigger);
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.checked("Unable to create the Quartz job and trigger", se);
        }
    }

    boolean unscheduleJob(JobId jobId) {
        Trigger trigger = this.getTrigger(jobId);
        if (trigger == null) {
            return false;
        }
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)trigger.getJobName());
        if (this.deleteTrigger(jobId) && !this.hasAnyTriggers(jobRunnerKey)) {
            this.deleteJob(jobRunnerKey);
        }
        return true;
    }

    void start() throws SchedulerServiceException {
        try {
            this.getScheduler().start();
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.checked("Quartz scheduler refused to start", se);
        }
    }

    void standby() throws SchedulerServiceException {
        try {
            this.getScheduler().standby();
        }
        catch (SchedulerException se) {
            throw Quartz1SchedulerFacade.checked("Quartz scheduler refused to enter standby mode", se);
        }
    }

    void shutdown() {
        try {
            this.getScheduler().shutdown();
        }
        catch (SchedulerException se) {
            LOG.error("Quartz scheduler did not shut down cleanly", (Throwable)se);
        }
    }

    @Deprecated
    Scheduler getQuartz() {
        return this.getScheduler();
    }

    private Scheduler getScheduler() {
        try {
            return (Scheduler)this.quartzRef.get();
        }
        catch (LazyReference.InitializationException ex) {
            throw Quartz1SchedulerFacade.unchecked("Error creating underlying Quartz scheduler", ex.getCause());
        }
    }

    private static void logWarn(String message, Object arg, Throwable e) {
        if (LOG.isDebugEnabled()) {
            LOG.warn(message, arg, (Object)e);
        } else {
            LOG.warn(message + ": {}", arg, (Object)e.toString());
        }
    }

    private static SchedulerServiceException checked(String message, Throwable e) {
        return new SchedulerServiceException(message, e);
    }

    private static SchedulerRuntimeException unchecked(String message, Throwable e) {
        return new SchedulerRuntimeException(message, e);
    }
}

