/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz1;

import com.atlassian.scheduler.SchedulerRuntimeException;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.AbstractSchedulerService;
import com.atlassian.scheduler.core.status.AbstractJobDetailsFactory;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class Quartz1JobDetailsFactory
extends AbstractJobDetailsFactory<Trigger> {
    Quartz1JobDetailsFactory(AbstractSchedulerService schedulerService) {
        super(schedulerService);
    }

    @Nonnull
    protected JobRunnerKey getJobRunnerKey(Trigger trigger) {
        return JobRunnerKey.of((String)trigger.getJobName());
    }

    @Nonnull
    protected Schedule getSchedule(Trigger trigger) {
        if (trigger instanceof CronTrigger) {
            CronTrigger cron = (CronTrigger)trigger;
            return Schedule.forCronExpression((String)cron.getCronExpression(), (TimeZone)cron.getTimeZone());
        }
        if (trigger instanceof SimpleTrigger) {
            SimpleTrigger simple = (SimpleTrigger)trigger;
            return Schedule.forInterval((long)simple.getRepeatInterval(), (Date)simple.getStartTime());
        }
        throw new SchedulerRuntimeException("The job with jobId '" + trigger.getName() + "' has an unsupported trigger class: " + trigger.getClass().getName());
    }

    @Nullable
    protected byte[] getSerializedParameters(Trigger trigger) {
        return (byte[])trigger.getJobDataMap().get((Object)"parameters");
    }

    @Nullable
    protected Date getNextRunTime(Trigger trigger) {
        return trigger.getNextFireTime();
    }
}

