/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.quartz1;

import com.atlassian.scheduler.core.util.LogWarn;
import java.sql.Connection;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.quartz.JobDetail;
import org.quartz.JobPersistenceException;
import org.quartz.Trigger;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.jdbcjobstore.JobStoreTX;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Quartz1HardenedJobStore
extends JobStoreTX {
    private static final Logger LOG = LoggerFactory.getLogger(Quartz1HardenedJobStore.class);
    private final ReentrantLock recoverJobsLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverJobs() throws JobPersistenceException {
        this.recoverJobsLock.lock();
        try {
            super.recoverJobs();
        }
        finally {
            this.recoverJobsLock.unlock();
        }
    }

    protected void storeTrigger(Connection conn, SchedulingContext ctxt, Trigger newTrigger, @Nullable JobDetail job, boolean replaceExisting, String state, boolean forceState, boolean recovering) throws JobPersistenceException {
        try {
            super.storeTrigger(conn, ctxt, newTrigger, job, replaceExisting, state, forceState, recovering);
        }
        catch (JobPersistenceException jpe) {
            if (!this.recoverJobsLock.isHeldByCurrentThread()) {
                throw jpe;
            }
            LogWarn.logWarn((Logger)LOG, (String)"Caught an exception storing trigger during scheduler recovery", (Throwable)jpe);
        }
    }
}

