/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.shorts.AbstractShort2CharMap;
import it.unimi.dsi.fastutil.shorts.AbstractShort2CharSortedMap;
import it.unimi.dsi.fastutil.shorts.AbstractShortSortedSet;
import it.unimi.dsi.fastutil.shorts.Short2CharMap;
import it.unimi.dsi.fastutil.shorts.Short2CharSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Short2CharLinkedOpenHashMap
extends AbstractShort2CharSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient short[] key;
    protected transient char[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Short2CharSortedMap.FastSortedEntrySet entries;
    protected volatile transient ShortSortedSet keys;
    protected volatile transient CharCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Short2CharLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new short[this.n];
        this.value = new char[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Short2CharLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Short2CharLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Short2CharLinkedOpenHashMap(Map<? extends Short, ? extends Character> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Short2CharLinkedOpenHashMap(Map<? extends Short, ? extends Character> m) {
        this(m, 0.75f);
    }

    public Short2CharLinkedOpenHashMap(Short2CharMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Short2CharLinkedOpenHashMap(Short2CharMap m) {
        this(m, 0.75f);
    }

    public Short2CharLinkedOpenHashMap(short[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Short2CharLinkedOpenHashMap(short[] k, char[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public char put(short k, char v) {
        short[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            char oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Character put(Short ok, Character ov) {
        char v = ov.charValue();
        short k = ok;
        short[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            Character oldValue = Character.valueOf(this.value[pos]);
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public char remove(short k) {
        short[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return this.defRetValue;
        }
        --this.size;
        this.fixPointers(pos);
        char v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    @Override
    public Character remove(Object ok) {
        short k = (Short)ok;
        short[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return null;
        }
        --this.size;
        this.fixPointers(pos);
        char v = this.value[pos];
        this.shiftKeys(pos);
        return Character.valueOf(v);
    }

    public Character get(Short ok) {
        short k = ok;
        short[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? Character.valueOf(this.value[pos]) : null;
    }

    @Override
    public char get(short k) {
        short[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? this.value[pos] : this.defRetValue;
    }

    @Override
    public boolean containsKey(short k) {
        short[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public boolean containsValue(char v) {
        char[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public short firstShortKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public short lastShortKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public ShortComparator comparator() {
        return null;
    }

    @Override
    public Short2CharSortedMap tailMap(short from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short2CharSortedMap headMap(short to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short2CharSortedMap subMap(short from, short to) {
        throw new UnsupportedOperationException();
    }

    public Short2CharSortedMap.FastSortedEntrySet short2CharEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ShortSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public CharCollection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                @Override
                public CharIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Short2CharLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(char v) {
                    return Short2CharLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Short2CharLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        short[] key = this.key;
        char[] value = this.value;
        int newMask = newN - 1;
        short[] newKey = new short[newN];
        char[] newValue = new char[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            short k = key[i];
            int pos = HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Short2CharLinkedOpenHashMap clone() {
        Short2CharLinkedOpenHashMap c;
        try {
            c = (Short2CharLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (short[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        short[] key = this.key;
        char[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeShort(key[e]);
            s.writeChar(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new short[this.n];
        short[] key = this.key;
        this.value = new char[this.n];
        char[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            short k = s.readShort();
            char v = s.readChar();
            pos = HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements CharListIterator {
        @Override
        public char previousChar() {
            return Short2CharLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Character previous() {
            return Character.valueOf(Short2CharLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        @Override
        public void set(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char nextChar() {
            return Short2CharLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Character next() {
            return Character.valueOf(Short2CharLinkedOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    private final class KeySet
    extends AbstractShortSortedSet {
        private KeySet() {
        }

        @Override
        public ShortBidirectionalIterator iterator(short from) {
            return new KeyIterator(from);
        }

        @Override
        public ShortBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Short2CharLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(short k) {
            return Short2CharLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(short k) {
            int oldSize = Short2CharLinkedOpenHashMap.this.size;
            Short2CharLinkedOpenHashMap.this.remove(k);
            return Short2CharLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Short2CharLinkedOpenHashMap.this.clear();
        }

        @Override
        public short firstShort() {
            if (Short2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Short2CharLinkedOpenHashMap.this.key[Short2CharLinkedOpenHashMap.this.first];
        }

        @Override
        public short lastShort() {
            if (Short2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Short2CharLinkedOpenHashMap.this.key[Short2CharLinkedOpenHashMap.this.last];
        }

        @Override
        public ShortComparator comparator() {
            return null;
        }

        @Override
        public final ShortSortedSet tailSet(short from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ShortSortedSet headSet(short to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ShortSortedSet subSet(short from, short to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ShortListIterator {
        public KeyIterator(short k) {
            super(k);
        }

        @Override
        public short previousShort() {
            return Short2CharLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(short k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(short k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Short previous() {
            return Short2CharLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(Short ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Short ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public short nextShort() {
            return Short2CharLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Short next() {
            return Short2CharLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Short2CharMap.Entry>
    implements Short2CharSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Short2CharMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Short2CharMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Short2CharMap.Entry> subSet(Short2CharMap.Entry fromElement, Short2CharMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Short2CharMap.Entry> headSet(Short2CharMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Short2CharMap.Entry> tailSet(Short2CharMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Short2CharMap.Entry first() {
            if (Short2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Short2CharLinkedOpenHashMap.this.first);
        }

        @Override
        public Short2CharMap.Entry last() {
            if (Short2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Short2CharLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            short[] key = Short2CharLinkedOpenHashMap.this.key;
            boolean[] used = Short2CharLinkedOpenHashMap.this.used;
            int mask = Short2CharLinkedOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(k) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            return used[pos] && Short2CharLinkedOpenHashMap.this.value[pos] == ((Character)e.getValue()).charValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            short k = (Short)e.getKey();
            short[] key = Short2CharLinkedOpenHashMap.this.key;
            boolean[] used = Short2CharLinkedOpenHashMap.this.used;
            int mask = Short2CharLinkedOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(k) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            if (used[pos]) {
                Short2CharLinkedOpenHashMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return Short2CharLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Short2CharLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Short2CharMap.Entry> iterator(Short2CharMap.Entry from) {
            return new EntryIterator((Short)from.getKey());
        }

        public ObjectBidirectionalIterator<Short2CharMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Short2CharMap.Entry> fastIterator(Short2CharMap.Entry from) {
            return new FastEntryIterator((Short)from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Short2CharMap.Entry> {
        final AbstractShort2CharMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractShort2CharMap.BasicEntry(0, '\u0000');
        }

        public FastEntryIterator(short from) {
            super(from);
            this.entry = new AbstractShort2CharMap.BasicEntry(0, '\u0000');
        }

        @Override
        public AbstractShort2CharMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Short2CharLinkedOpenHashMap.this.key[e];
            this.entry.value = Short2CharLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractShort2CharMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Short2CharLinkedOpenHashMap.this.key[e];
            this.entry.value = Short2CharLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Short2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Short2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Short2CharMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(short from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Short2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Short2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Short2CharLinkedOpenHashMap.this.first;
        }

        private MapIterator(short from) {
            if (Short2CharLinkedOpenHashMap.this.key[Short2CharLinkedOpenHashMap.this.last] == from) {
                this.prev = Short2CharLinkedOpenHashMap.this.last;
                this.index = Short2CharLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Short2CharLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Short2CharLinkedOpenHashMap.this.first;
                while (Short2CharLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Short2CharLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Short2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Short2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Short2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Short2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Short2CharLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Short2CharLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Short2CharLinkedOpenHashMap.this.link[n] = Short2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Short2CharLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Short2CharLinkedOpenHashMap.this.link[n] = Short2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Short2CharLinkedOpenHashMap.this.mask;
                while (Short2CharLinkedOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Short2CharLinkedOpenHashMap.this.key[pos]) & Short2CharLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Short2CharLinkedOpenHashMap.this.mask;
                }
                if (!Short2CharLinkedOpenHashMap.this.used[pos]) break;
                Short2CharLinkedOpenHashMap.this.key[last] = Short2CharLinkedOpenHashMap.this.key[pos];
                Short2CharLinkedOpenHashMap.this.value[last] = Short2CharLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Short2CharLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Short2CharLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Short2CharMap.Entry,
    Map.Entry<Short, Character> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Short getKey() {
            return Short2CharLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public short getShortKey() {
            return Short2CharLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Character getValue() {
            return Character.valueOf(Short2CharLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        public char getCharValue() {
            return Short2CharLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public char setValue(char v) {
            char oldValue = Short2CharLinkedOpenHashMap.this.value[this.index];
            Short2CharLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Character setValue(Character v) {
            return Character.valueOf(this.setValue(v.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Short2CharLinkedOpenHashMap.this.key[this.index] == (Short)e.getKey() && Short2CharLinkedOpenHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return Short2CharLinkedOpenHashMap.this.key[this.index] ^ Short2CharLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Short2CharLinkedOpenHashMap.this.key[this.index] + "=>" + Short2CharLinkedOpenHashMap.this.value[this.index];
        }
    }
}

