/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractReference2CharMap;
import it.unimi.dsi.fastutil.objects.AbstractReference2CharSortedMap;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.Reference2CharMap;
import it.unimi.dsi.fastutil.objects.Reference2CharSortedMap;
import it.unimi.dsi.fastutil.objects.ReferenceSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Reference2CharLinkedOpenHashMap<K>
extends AbstractReference2CharSortedMap<K>
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient char[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Reference2CharSortedMap.FastSortedEntrySet<K> entries;
    protected volatile transient ReferenceSortedSet<K> keys;
    protected volatile transient CharCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Reference2CharLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n];
        this.value = new char[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Reference2CharLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Reference2CharLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Reference2CharLinkedOpenHashMap(Map<? extends K, ? extends Character> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2CharLinkedOpenHashMap(Map<? extends K, ? extends Character> m) {
        this(m, 0.75f);
    }

    public Reference2CharLinkedOpenHashMap(Reference2CharMap<K> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Reference2CharLinkedOpenHashMap(Reference2CharMap<K> m) {
        this(m, 0.75f);
    }

    public Reference2CharLinkedOpenHashMap(K[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Reference2CharLinkedOpenHashMap(K[] k, char[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public char put(K k, char v) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            char oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Character put(K ok, Character ov) {
        char v = ov.charValue();
        K k = ok;
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            Character oldValue = Character.valueOf(this.value[pos]);
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(this.key[pos]))) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
        this.key[last] = null;
    }

    @Override
    public char removeChar(Object k) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return this.defRetValue;
        }
        --this.size;
        this.fixPointers(pos);
        char v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    @Override
    public Character remove(Object ok) {
        Object k = ok;
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return null;
        }
        --this.size;
        this.fixPointers(pos);
        char v = this.value[pos];
        this.shiftKeys(pos);
        return Character.valueOf(v);
    }

    @Override
    public char getChar(Object k) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? this.value[pos] : this.defRetValue;
    }

    @Override
    public boolean containsKey(Object k) {
        K[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public boolean containsValue(char v) {
        char[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public K firstKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public K lastKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public Reference2CharSortedMap<K> tailMap(K from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reference2CharSortedMap<K> headMap(K to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reference2CharSortedMap<K> subMap(K from, K to) {
        throw new UnsupportedOperationException();
    }

    public Reference2CharSortedMap.FastSortedEntrySet<K> reference2CharEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ReferenceSortedSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public CharCollection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                @Override
                public CharIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Reference2CharLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(char v) {
                    return Reference2CharLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Reference2CharLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        K[] key = this.key;
        char[] value = this.value;
        int newMask = newN - 1;
        Object[] newKey = new Object[newN];
        char[] newValue = new char[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            K k = key[i];
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Reference2CharLinkedOpenHashMap<K> clone() {
        Reference2CharLinkedOpenHashMap c;
        try {
            c = (Reference2CharLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            if (this != this.key[i]) {
                t = this.key[i] == null ? 0 : System.identityHashCode(this.key[i]);
            }
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        char[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeChar(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.value = new char[this.n];
        char[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            Object k = s.readObject();
            char v = s.readChar();
            pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements CharListIterator {
        @Override
        public char previousChar() {
            return Reference2CharLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Character previous() {
            return Character.valueOf(Reference2CharLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        @Override
        public void set(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char nextChar() {
            return Reference2CharLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Character next() {
            return Character.valueOf(Reference2CharLinkedOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    private final class KeySet
    extends AbstractReferenceSortedSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator(K from) {
            return new KeyIterator(from);
        }

        @Override
        public ObjectBidirectionalIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Reference2CharLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Reference2CharLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Reference2CharLinkedOpenHashMap.this.size;
            Reference2CharLinkedOpenHashMap.this.remove(k);
            return Reference2CharLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Reference2CharLinkedOpenHashMap.this.clear();
        }

        @Override
        public K first() {
            if (Reference2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Reference2CharLinkedOpenHashMap.this.key[Reference2CharLinkedOpenHashMap.this.first];
        }

        @Override
        public K last() {
            if (Reference2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Reference2CharLinkedOpenHashMap.this.key[Reference2CharLinkedOpenHashMap.this.last];
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public final ReferenceSortedSet<K> tailSet(K from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ReferenceSortedSet<K> headSet(K to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final ReferenceSortedSet<K> subSet(K from, K to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectListIterator<K> {
        public KeyIterator(K k) {
            super(k);
        }

        @Override
        public K previous() {
            return Reference2CharLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(K k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(K k) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public K next() {
            return Reference2CharLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Reference2CharMap.Entry<K>>
    implements Reference2CharSortedMap.FastSortedEntrySet<K> {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Reference2CharMap.Entry<K>> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Reference2CharMap.Entry<K>> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Reference2CharMap.Entry<K>> subSet(Reference2CharMap.Entry<K> fromElement, Reference2CharMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Reference2CharMap.Entry<K>> headSet(Reference2CharMap.Entry<K> toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Reference2CharMap.Entry<K>> tailSet(Reference2CharMap.Entry<K> fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference2CharMap.Entry<K> first() {
            if (Reference2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Reference2CharLinkedOpenHashMap.this.first);
        }

        @Override
        public Reference2CharMap.Entry<K> last() {
            if (Reference2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Reference2CharLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            K[] key = Reference2CharLinkedOpenHashMap.this.key;
            boolean[] used = Reference2CharLinkedOpenHashMap.this.used;
            int mask = Reference2CharLinkedOpenHashMap.this.mask;
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            return used[pos] && Reference2CharLinkedOpenHashMap.this.value[pos] == ((Character)e.getValue()).charValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            K[] key = Reference2CharLinkedOpenHashMap.this.key;
            boolean[] used = Reference2CharLinkedOpenHashMap.this.used;
            int mask = Reference2CharLinkedOpenHashMap.this.mask;
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(k))) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            if (used[pos]) {
                Reference2CharLinkedOpenHashMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return Reference2CharLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Reference2CharLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Reference2CharMap.Entry<K>> iterator(Reference2CharMap.Entry<K> from) {
            return new EntryIterator(from.getKey());
        }

        @Override
        public ObjectBidirectionalIterator<Reference2CharMap.Entry<K>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Reference2CharMap.Entry<K>> fastIterator(Reference2CharMap.Entry<K> from) {
            return new FastEntryIterator(from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Reference2CharMap.Entry<K>> {
        final AbstractReference2CharMap.BasicEntry<K> entry;

        public FastEntryIterator() {
            this.entry = new AbstractReference2CharMap.BasicEntry<Object>(null, '\u0000');
        }

        public FastEntryIterator(K from) {
            super(from);
            this.entry = new AbstractReference2CharMap.BasicEntry<Object>(null, '\u0000');
        }

        @Override
        public AbstractReference2CharMap.BasicEntry<K> next() {
            int e = this.nextEntry();
            this.entry.key = Reference2CharLinkedOpenHashMap.this.key[e];
            this.entry.value = Reference2CharLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractReference2CharMap.BasicEntry<K> previous() {
            int e = this.previousEntry();
            this.entry.key = Reference2CharLinkedOpenHashMap.this.key[e];
            this.entry.value = Reference2CharLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Reference2CharMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Reference2CharMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Reference2CharMap.Entry<K>> {
        public EntryIterator() {
        }

        public EntryIterator(K from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Reference2CharMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Reference2CharMap.Entry<K> ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Reference2CharLinkedOpenHashMap.this.first;
        }

        private MapIterator(K from) {
            if (Reference2CharLinkedOpenHashMap.this.key[Reference2CharLinkedOpenHashMap.this.last] == from) {
                this.prev = Reference2CharLinkedOpenHashMap.this.last;
                this.index = Reference2CharLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Reference2CharLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Reference2CharLinkedOpenHashMap.this.first;
                while (Reference2CharLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Reference2CharLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Reference2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Reference2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Reference2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Reference2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Reference2CharLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Reference2CharLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Reference2CharLinkedOpenHashMap.this.link[n] = Reference2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Reference2CharLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Reference2CharLinkedOpenHashMap.this.link[n] = Reference2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Reference2CharLinkedOpenHashMap.this.mask;
                while (Reference2CharLinkedOpenHashMap.this.used[pos]) {
                    int slot = (Reference2CharLinkedOpenHashMap.this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(System.identityHashCode(Reference2CharLinkedOpenHashMap.this.key[pos]))) & Reference2CharLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Reference2CharLinkedOpenHashMap.this.mask;
                }
                if (!Reference2CharLinkedOpenHashMap.this.used[pos]) break;
                Reference2CharLinkedOpenHashMap.this.key[last] = Reference2CharLinkedOpenHashMap.this.key[pos];
                Reference2CharLinkedOpenHashMap.this.value[last] = Reference2CharLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Reference2CharLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Reference2CharLinkedOpenHashMap.this.used[last] = false;
            Reference2CharLinkedOpenHashMap.this.key[last] = null;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Reference2CharMap.Entry<K>,
    Map.Entry<K, Character> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Reference2CharLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Character getValue() {
            return Character.valueOf(Reference2CharLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        public char getCharValue() {
            return Reference2CharLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public char setValue(char v) {
            char oldValue = Reference2CharLinkedOpenHashMap.this.value[this.index];
            Reference2CharLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Character setValue(Character v) {
            return Character.valueOf(this.setValue(v.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Reference2CharLinkedOpenHashMap.this.key[this.index] == e.getKey() && Reference2CharLinkedOpenHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return (Reference2CharLinkedOpenHashMap.this.key[this.index] == null ? 0 : System.identityHashCode(Reference2CharLinkedOpenHashMap.this.key[this.index])) ^ Reference2CharLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Reference2CharLinkedOpenHashMap.this.key[this.index] + "=>" + Reference2CharLinkedOpenHashMap.this.value[this.index];
        }
    }
}

