/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.ints.AbstractInt2LongMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.AbstractLongCollection;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Int2LongOpenHashMap
extends AbstractInt2LongMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient int[] key;
    protected transient long[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Int2LongMap.FastEntrySet entries;
    protected volatile transient IntSet keys;
    protected volatile transient LongCollection values;

    public Int2LongOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new int[this.n];
        this.value = new long[this.n];
        this.used = new boolean[this.n];
    }

    public Int2LongOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2LongOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2LongOpenHashMap(Map<? extends Integer, ? extends Long> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2LongOpenHashMap(Map<? extends Integer, ? extends Long> m) {
        this(m, 0.75f);
    }

    public Int2LongOpenHashMap(Int2LongMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Int2LongOpenHashMap(Int2LongMap m) {
        this(m, 0.75f);
    }

    public Int2LongOpenHashMap(int[] k, long[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Int2LongOpenHashMap(int[] k, long[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public long put(int k, long v) {
        int[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            long oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Long put(Integer ok, Long ov) {
        long v = ov;
        int k = ok;
        int[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            Long oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
    }

    @Override
    public long remove(int k) {
        int[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return this.defRetValue;
        }
        --this.size;
        long v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    @Override
    public Long remove(Object ok) {
        int k = (Integer)ok;
        int[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return null;
        }
        --this.size;
        long v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public Long get(Integer ok) {
        int k = ok;
        int[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? Long.valueOf(this.value[pos]) : null;
    }

    @Override
    public long get(int k) {
        int[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? this.value[pos] : this.defRetValue;
    }

    @Override
    public boolean containsKey(int k) {
        int[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public boolean containsValue(long v) {
        long[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Int2LongMap.FastEntrySet int2LongEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public LongCollection values() {
        if (this.values == null) {
            this.values = new AbstractLongCollection(){

                @Override
                public LongIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Int2LongOpenHashMap.this.size;
                }

                @Override
                public boolean contains(long v) {
                    return Int2LongOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Int2LongOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        int[] key = this.key;
        long[] value = this.value;
        int newMask = newN - 1;
        int[] newKey = new int[newN];
        long[] newValue = new long[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            int k = key[i];
            int pos = HashCommon.murmurHash3(k) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Int2LongOpenHashMap clone() {
        Int2LongOpenHashMap c;
        try {
            c = (Int2LongOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (int[])this.key.clone();
        c.value = (long[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= HashCommon.long2int(this.value[i]));
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int[] key = this.key;
        long[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeInt(key[e]);
            s.writeLong(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n];
        int[] key = this.key;
        this.value = new long[this.n];
        long[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            int k = s.readInt();
            long v = s.readLong();
            pos = HashCommon.murmurHash3(k) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements LongIterator {
        @Override
        public long nextLong() {
            return Int2LongOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Long next() {
            return Int2LongOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        @Override
        public IntIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Int2LongOpenHashMap.this.size;
        }

        @Override
        public boolean contains(int k) {
            return Int2LongOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(int k) {
            int oldSize = Int2LongOpenHashMap.this.size;
            Int2LongOpenHashMap.this.remove(k);
            return Int2LongOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Int2LongOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements IntIterator {
        @Override
        public int nextInt() {
            return Int2LongOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Integer next() {
            return Int2LongOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Int2LongMap.Entry>
    implements Int2LongMap.FastEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Int2LongMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Int2LongMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int k = (Integer)e.getKey();
            int[] key = Int2LongOpenHashMap.this.key;
            boolean[] used = Int2LongOpenHashMap.this.used;
            int mask = Int2LongOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(k) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            return used[pos] && Int2LongOpenHashMap.this.value[pos] == (Long)e.getValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            int k = (Integer)e.getKey();
            int[] key = Int2LongOpenHashMap.this.key;
            boolean[] used = Int2LongOpenHashMap.this.used;
            int mask = Int2LongOpenHashMap.this.mask;
            int pos = HashCommon.murmurHash3(k) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            if (used[pos]) {
                Int2LongOpenHashMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return Int2LongOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Int2LongOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Int2LongMap.Entry> {
        final AbstractInt2LongMap.BasicEntry entry;

        private FastEntryIterator() {
            this.entry = new AbstractInt2LongMap.BasicEntry(0, 0L);
        }

        @Override
        public AbstractInt2LongMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Int2LongOpenHashMap.this.key[e];
            this.entry.value = Int2LongOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Int2LongMap.Entry> {
        private EntryIterator() {
        }

        @Override
        public Int2LongMap.Entry next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Int2LongOpenHashMap.this.n;
            this.last = -1;
            this.c = Int2LongOpenHashMap.this.size;
            boolean[] used = Int2LongOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Int2LongOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Int2LongOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            Int2LongOpenHashMap.this.shiftKeys(this.last);
            --Int2LongOpenHashMap.this.size;
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Int2LongMap.Entry,
    Map.Entry<Integer, Long> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Integer getKey() {
            return Int2LongOpenHashMap.this.key[this.index];
        }

        @Override
        public int getIntKey() {
            return Int2LongOpenHashMap.this.key[this.index];
        }

        @Override
        public Long getValue() {
            return Int2LongOpenHashMap.this.value[this.index];
        }

        @Override
        public long getLongValue() {
            return Int2LongOpenHashMap.this.value[this.index];
        }

        @Override
        public long setValue(long v) {
            long oldValue = Int2LongOpenHashMap.this.value[this.index];
            Int2LongOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Long setValue(Long v) {
            return this.setValue((long)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Int2LongOpenHashMap.this.key[this.index] == (Integer)e.getKey() && Int2LongOpenHashMap.this.value[this.index] == (Long)e.getValue();
        }

        @Override
        public int hashCode() {
            return Int2LongOpenHashMap.this.key[this.index] ^ HashCommon.long2int(Int2LongOpenHashMap.this.value[this.index]);
        }

        public String toString() {
            return Int2LongOpenHashMap.this.key[this.index] + "=>" + Int2LongOpenHashMap.this.value[this.index];
        }
    }
}

