/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.floats.FloatComparator;
import java.io.Serializable;

public class FloatArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final float[] EMPTY_ARRAY = new float[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 40;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private FloatArrays() {
    }

    public static float[] ensureCapacity(float[] array, int length) {
        if (length > array.length) {
            float[] t = new float[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static float[] ensureCapacity(float[] array, int length, int preserve) {
        if (length > array.length) {
            float[] t = new float[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static float[] grow(float[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            float[] t = new float[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static float[] grow(float[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            float[] t = new float[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static float[] trim(float[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        float[] t = length == 0 ? EMPTY_ARRAY : new float[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static float[] setLength(float[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return FloatArrays.trim(array, length);
        }
        return FloatArrays.ensureCapacity(array, length);
    }

    public static float[] copy(float[] array, int offset, int length) {
        FloatArrays.ensureOffsetLength(array, offset, length);
        float[] a = length == 0 ? EMPTY_ARRAY : new float[length];
        System.arraycopy(array, offset, a, 0, length);
        return a;
    }

    public static float[] copy(float[] array) {
        return (float[])array.clone();
    }

    public static void fill(float[] array, float value) {
        int i = array.length;
        while (i-- != 0) {
            array[i] = value;
        }
    }

    public static void fill(float[] array, int from, int to, float value) {
        FloatArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i = from; i < to; ++i) {
                array[i] = value;
            }
        }
    }

    public static boolean equals(float[] a1, float[] a2) {
        int i = a1.length;
        if (i != a2.length) {
            return false;
        }
        while (i-- != 0) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(float[] a, int from, int to) {
        Arrays.ensureFromTo(a.length, from, to);
    }

    public static void ensureOffsetLength(float[] a, int offset, int length) {
        Arrays.ensureOffsetLength(a.length, offset, length);
    }

    private static void swap(float[] x, int a, int b) {
        float t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private static void vecSwap(float[] x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            FloatArrays.swap(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private static int med3(float[] x, int a, int b, int c, FloatComparator comp) {
        int ab = comp.compare(x[a], x[b]);
        int ac = comp.compare(x[a], x[c]);
        int bc = comp.compare(x[b], x[c]);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(float[] x, int from, int to, FloatComparator comp) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && comp.compare(x[j - 1], x[j]) > 0; --j) {
                    FloatArrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = FloatArrays.med3(x, l, l + s, l + 2 * s, comp);
                m = FloatArrays.med3(x, m - s, m, m + s, comp);
                n = FloatArrays.med3(x, n - 2 * s, n - s, n, comp);
            }
            m = FloatArrays.med3(x, l, m, n, comp);
        }
        float v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (comparison = comp.compare(x[b], v)) <= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        FloatArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        FloatArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            FloatArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d - c) > 1) {
            FloatArrays.quickSort(x, n - s, n, comp);
        }
    }

    public static void quickSort(float[] x, FloatComparator comp) {
        FloatArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(float[] x, int a, int b, int c) {
        int bc;
        int ac;
        int ab;
        int n = x[a] < x[b] ? -1 : (ab = x[a] == x[b] ? 0 : 1);
        int n2 = x[a] < x[c] ? -1 : (ac = x[a] == x[c] ? 0 : 1);
        int n3 = x[b] < x[c] ? -1 : (bc = x[b] == x[c] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b : (ac < 0 ? c : a)) : (bc > 0 ? b : (ac > 0 ? c : a));
    }

    public static void quickSort(float[] x, int from, int to) {
        int c;
        int a;
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && x[j] < x[j - 1]; --j) {
                    FloatArrays.swap(x, j, j - 1);
                }
            }
            return;
        }
        int m = from + len / 2;
        if (len > 7) {
            int l = from;
            int n = to - 1;
            if (len > 40) {
                int s = len / 8;
                l = FloatArrays.med3(x, l, l + s, l + 2 * s);
                m = FloatArrays.med3(x, m - s, m, m + s);
                n = FloatArrays.med3(x, n - 2 * s, n - s, n);
            }
            m = FloatArrays.med3(x, l, m, n);
        }
        float v = x[m];
        int b = a = from;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b <= c && (x[b] < v ? -1 : (comparison = x[b] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (x[c] < v ? -1 : (comparison = x[c] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    FloatArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            FloatArrays.swap(x, b++, c--);
        }
        int n = to;
        int s = Math.min(a - from, b - a);
        FloatArrays.vecSwap(x, from, b - s, s);
        s = Math.min(d - c, n - d - 1);
        FloatArrays.vecSwap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            FloatArrays.quickSort(x, from, from + s);
        }
        if ((s = d - c) > 1) {
            FloatArrays.quickSort(x, n - s, n);
        }
    }

    public static void quickSort(float[] x) {
        FloatArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(float[] a, int from, int to, float[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && a[j] < a[j - 1]; --j) {
                    FloatArrays.swap(a, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        FloatArrays.mergeSort(supp, from, mid, a);
        FloatArrays.mergeSort(supp, mid, to, a);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && supp[p] <= supp[q] ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from, int to) {
        FloatArrays.mergeSort(a, from, to, (float[])a.clone());
    }

    public static void mergeSort(float[] a) {
        FloatArrays.mergeSort(a, 0, a.length);
    }

    public static void mergeSort(float[] a, int from, int to, FloatComparator comp, float[] supp) {
        int len = to - from;
        if (len < 7) {
            for (int i = from; i < to; ++i) {
                for (int j = i; j > from && comp.compare(a[j - 1], a[j]) > 0; --j) {
                    FloatArrays.swap(a, j, j - 1);
                }
            }
            return;
        }
        int mid = from + to >>> 1;
        FloatArrays.mergeSort(supp, from, mid, comp, a);
        FloatArrays.mergeSort(supp, mid, to, comp, a);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a, from, len);
            return;
        }
        int p = from;
        int q = mid;
        for (int i = from; i < to; ++i) {
            a[i] = q >= to || p < mid && comp.compare(supp[p], supp[q]) <= 0 ? supp[p++] : supp[q++];
        }
    }

    public static void mergeSort(float[] a, int from, int to, FloatComparator comp) {
        FloatArrays.mergeSort(a, from, to, comp, (float[])a.clone());
    }

    public static void mergeSort(float[] a, FloatComparator comp) {
        FloatArrays.mergeSort(a, 0, a.length, comp);
    }

    public static int binarySearch(float[] a, int from, int to, float key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            float midVal = a[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(float[] a, float key) {
        return FloatArrays.binarySearch(a, 0, a.length, key);
    }

    public static int binarySearch(float[] a, int from, int to, float key, FloatComparator c) {
        while (from <= to) {
            int mid = from + to >>> 1;
            float midVal = a[mid];
            int cmp = c.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(float[] a, float key, FloatComparator c) {
        return FloatArrays.binarySearch(a, 0, a.length, key, c);
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<float[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(float[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(float[] a, float[] b) {
            return FloatArrays.equals(a, b);
        }
    }
}

