/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2CharMap;
import it.unimi.dsi.fastutil.doubles.AbstractDouble2CharSortedMap;
import it.unimi.dsi.fastutil.doubles.AbstractDoubleSortedSet;
import it.unimi.dsi.fastutil.doubles.Double2CharMap;
import it.unimi.dsi.fastutil.doubles.Double2CharSortedMap;
import it.unimi.dsi.fastutil.doubles.DoubleBidirectionalIterator;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Double2CharLinkedOpenHashMap
extends AbstractDouble2CharSortedMap
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient double[] key;
    protected transient char[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Double2CharSortedMap.FastSortedEntrySet entries;
    protected volatile transient DoubleSortedSet keys;
    protected volatile transient CharCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient int[] link;

    public Double2CharLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new double[this.n];
        this.value = new char[this.n];
        this.used = new boolean[this.n];
        this.link = new int[this.n];
    }

    public Double2CharLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Double2CharLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Double2CharLinkedOpenHashMap(Map<? extends Double, ? extends Character> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2CharLinkedOpenHashMap(Map<? extends Double, ? extends Character> m) {
        this(m, 0.75f);
    }

    public Double2CharLinkedOpenHashMap(Double2CharMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Double2CharLinkedOpenHashMap(Double2CharMap m) {
        this(m, 0.75f);
    }

    public Double2CharLinkedOpenHashMap(double[] k, char[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Double2CharLinkedOpenHashMap(double[] k, char[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public char put(double k, char v) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            char oldValue = this.value[pos];
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Character put(Double ok, Character ov) {
        char v = ov.charValue();
        double k = ok;
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (used[pos]) {
            Character oldValue = Character.valueOf(this.value[pos]);
            this.value[pos] = v;
            return oldValue;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = 0;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ ~pos;
            this.link[pos] = ~this.last;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return null;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(this.key[pos])) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
    }

    @Override
    public char remove(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return this.defRetValue;
        }
        --this.size;
        this.fixPointers(pos);
        char v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    @Override
    public Character remove(Object ok) {
        double k = (Double)ok;
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        if (!used[pos]) {
            return null;
        }
        --this.size;
        this.fixPointers(pos);
        char v = this.value[pos];
        this.shiftKeys(pos);
        return Character.valueOf(v);
    }

    public Character get(Double ok) {
        double k = ok;
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? Character.valueOf(this.value[pos]) : null;
    }

    @Override
    public char get(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos] ? this.value[pos] : this.defRetValue;
    }

    @Override
    public boolean containsKey(double k) {
        double[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
        while (used[pos] && k != key[pos]) {
            pos = pos + 1 & mask;
        }
        return used[pos];
    }

    @Override
    public boolean containsValue(char v) {
        char[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        int next;
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            int n = this.first = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        if (this.last == i) {
            int n = this.last = ~this.link[i];
            this.link[n] = this.link[n] ^ ~i;
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != i) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (this.link[i] ^ i ^ j);
        int n2 = this.link[i] ^ j;
        this.link[n2] = this.link[n2] ^ (i ^ j);
    }

    protected void fixPointers(int s, int d) {
        int next;
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = 0;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = ~this.link[s];
            this.link[n] = this.link[n] ^ (s ^ d);
            this.link[d] = this.link[s];
            return;
        }
        int j = this.first;
        int prev = -1;
        while ((next = this.link[j] ^ prev) != s) {
            prev = j;
            j = next;
        }
        int n = j;
        this.link[n] = this.link[n] ^ (s ^ d);
        int n2 = this.link[s] ^ j;
        this.link[n2] = this.link[n2] ^ (s ^ d);
        this.link[d] = this.link[s];
    }

    @Override
    public double firstDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public double lastDoubleKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public DoubleComparator comparator() {
        return null;
    }

    @Override
    public Double2CharSortedMap tailMap(double from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2CharSortedMap headMap(double to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double2CharSortedMap subMap(double from, double to) {
        throw new UnsupportedOperationException();
    }

    public Double2CharSortedMap.FastSortedEntrySet double2CharEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public DoubleSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public CharCollection values() {
        if (this.values == null) {
            this.values = new AbstractCharCollection(){

                @Override
                public CharIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Double2CharLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(char v) {
                    return Double2CharLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Double2CharLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        double[] key = this.key;
        char[] value = this.value;
        int newMask = newN - 1;
        double[] newKey = new double[newN];
        char[] newValue = new char[newN];
        boolean[] newUsed = new boolean[newN];
        int[] link = this.link;
        int[] newLink = new int[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            double k = key[i];
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ pos;
                newLink[pos] = newPrev;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1;
            }
            int t = i;
            i = link[i] ^ prev;
            prev = t;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = ~newLink[n];
        }
    }

    public Double2CharLinkedOpenHashMap clone() {
        Double2CharLinkedOpenHashMap c;
        try {
            c = (Double2CharLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (double[])this.key.clone();
        c.value = (char[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (int[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = HashCommon.double2int(this.key[i]);
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        double[] key = this.key;
        char[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeDouble(key[e]);
            s.writeChar(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new double[this.n];
        double[] key = this.key;
        this.value = new char[this.n];
        char[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new int[this.n];
        int[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            double k = s.readDouble();
            char v = s.readChar();
            pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ pos;
                link[pos] = prev;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            link[pos] = -1;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = ~link[n];
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements CharListIterator {
        @Override
        public char previousChar() {
            return Double2CharLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Character previous() {
            return Character.valueOf(Double2CharLinkedOpenHashMap.this.value[this.previousEntry()]);
        }

        @Override
        public void set(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(char v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public char nextChar() {
            return Double2CharLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Character next() {
            return Character.valueOf(Double2CharLinkedOpenHashMap.this.value[this.nextEntry()]);
        }
    }

    private final class KeySet
    extends AbstractDoubleSortedSet {
        private KeySet() {
        }

        @Override
        public DoubleBidirectionalIterator iterator(double from) {
            return new KeyIterator(from);
        }

        @Override
        public DoubleBidirectionalIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Double2CharLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(double k) {
            return Double2CharLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(double k) {
            int oldSize = Double2CharLinkedOpenHashMap.this.size;
            Double2CharLinkedOpenHashMap.this.remove(k);
            return Double2CharLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Double2CharLinkedOpenHashMap.this.clear();
        }

        @Override
        public double firstDouble() {
            if (Double2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2CharLinkedOpenHashMap.this.key[Double2CharLinkedOpenHashMap.this.first];
        }

        @Override
        public double lastDouble() {
            if (Double2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Double2CharLinkedOpenHashMap.this.key[Double2CharLinkedOpenHashMap.this.last];
        }

        @Override
        public DoubleComparator comparator() {
            return null;
        }

        @Override
        public final DoubleSortedSet tailSet(double from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet headSet(double to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final DoubleSortedSet subSet(double from, double to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements DoubleListIterator {
        public KeyIterator(double k) {
            super(k);
        }

        @Override
        public double previousDouble() {
            return Double2CharLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(double k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double previous() {
            return Double2CharLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(Double ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public double nextDouble() {
            return Double2CharLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Double next() {
            return Double2CharLinkedOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Double2CharMap.Entry>
    implements Double2CharSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Double2CharMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Double2CharMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Double2CharMap.Entry> subSet(Double2CharMap.Entry fromElement, Double2CharMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2CharMap.Entry> headSet(Double2CharMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Double2CharMap.Entry> tailSet(Double2CharMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double2CharMap.Entry first() {
            if (Double2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2CharLinkedOpenHashMap.this.first);
        }

        @Override
        public Double2CharMap.Entry last() {
            if (Double2CharLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Double2CharLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            double[] key = Double2CharLinkedOpenHashMap.this.key;
            boolean[] used = Double2CharLinkedOpenHashMap.this.used;
            int mask = Double2CharLinkedOpenHashMap.this.mask;
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            return used[pos] && Double2CharLinkedOpenHashMap.this.value[pos] == ((Character)e.getValue()).charValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            double k = (Double)e.getKey();
            double[] key = Double2CharLinkedOpenHashMap.this.key;
            boolean[] used = Double2CharLinkedOpenHashMap.this.used;
            int mask = Double2CharLinkedOpenHashMap.this.mask;
            int pos = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(k)) & mask;
            while (used[pos] && k != key[pos]) {
                pos = pos + 1 & mask;
            }
            if (used[pos]) {
                Double2CharLinkedOpenHashMap.this.remove(e.getKey());
                return true;
            }
            return false;
        }

        @Override
        public int size() {
            return Double2CharLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Double2CharLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Double2CharMap.Entry> iterator(Double2CharMap.Entry from) {
            return new EntryIterator((Double)from.getKey());
        }

        public ObjectBidirectionalIterator<Double2CharMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Double2CharMap.Entry> fastIterator(Double2CharMap.Entry from) {
            return new FastEntryIterator((Double)from.getKey());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2CharMap.Entry> {
        final AbstractDouble2CharMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractDouble2CharMap.BasicEntry(0.0, '\u0000');
        }

        public FastEntryIterator(double from) {
            super(from);
            this.entry = new AbstractDouble2CharMap.BasicEntry(0.0, '\u0000');
        }

        @Override
        public AbstractDouble2CharMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Double2CharLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2CharLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractDouble2CharMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Double2CharLinkedOpenHashMap.this.key[e];
            this.entry.value = Double2CharLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Double2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Double2CharMap.Entry> {
        public EntryIterator() {
        }

        public EntryIterator(double from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            return new MapEntry(this.nextEntry());
        }

        @Override
        public MapEntry previous() {
            return new MapEntry(this.previousEntry());
        }

        @Override
        public void set(Double2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Double2CharMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = 0;

        private MapIterator() {
            this.next = Double2CharLinkedOpenHashMap.this.first;
        }

        private MapIterator(double from) {
            if (Double2CharLinkedOpenHashMap.this.key[Double2CharLinkedOpenHashMap.this.last] == from) {
                this.prev = Double2CharLinkedOpenHashMap.this.last;
                this.index = Double2CharLinkedOpenHashMap.this.size;
            } else {
                int e;
                if (!Double2CharLinkedOpenHashMap.this.containsKey(from)) {
                    throw new IllegalArgumentException("The key " + from + " does not belong to this set.");
                }
                this.next = Double2CharLinkedOpenHashMap.this.first;
                while (Double2CharLinkedOpenHashMap.this.key[e = this.nextEntry()] != from) {
                }
                this.curr = -1;
            }
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Double2CharLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = Double2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            this.prev = this.curr;
            ++this.index;
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = Double2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            this.next = this.curr;
            --this.index;
            return this.curr;
        }

        public void remove() {
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = Double2CharLinkedOpenHashMap.this.link[this.curr] ^ this.next;
            } else {
                this.next = Double2CharLinkedOpenHashMap.this.link[this.curr] ^ this.prev;
            }
            --Double2CharLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Double2CharLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Double2CharLinkedOpenHashMap.this.link[n] = Double2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.next);
            }
            if (this.next == -1) {
                Double2CharLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Double2CharLinkedOpenHashMap.this.link[n] = Double2CharLinkedOpenHashMap.this.link[n] ^ (this.curr ^ this.prev);
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Double2CharLinkedOpenHashMap.this.mask;
                while (Double2CharLinkedOpenHashMap.this.used[pos]) {
                    int slot = (int)HashCommon.murmurHash3(Double.doubleToRawLongBits(Double2CharLinkedOpenHashMap.this.key[pos])) & Double2CharLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Double2CharLinkedOpenHashMap.this.mask;
                }
                if (!Double2CharLinkedOpenHashMap.this.used[pos]) break;
                Double2CharLinkedOpenHashMap.this.key[last] = Double2CharLinkedOpenHashMap.this.key[pos];
                Double2CharLinkedOpenHashMap.this.value[last] = Double2CharLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Double2CharLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Double2CharLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Double2CharMap.Entry,
    Map.Entry<Double, Character> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Double getKey() {
            return Double2CharLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public double getDoubleKey() {
            return Double2CharLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Character getValue() {
            return Character.valueOf(Double2CharLinkedOpenHashMap.this.value[this.index]);
        }

        @Override
        public char getCharValue() {
            return Double2CharLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public char setValue(char v) {
            char oldValue = Double2CharLinkedOpenHashMap.this.value[this.index];
            Double2CharLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Character setValue(Character v) {
            return Character.valueOf(this.setValue(v.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Double2CharLinkedOpenHashMap.this.key[this.index] == (Double)e.getKey() && Double2CharLinkedOpenHashMap.this.value[this.index] == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(Double2CharLinkedOpenHashMap.this.key[this.index]) ^ Double2CharLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Double2CharLinkedOpenHashMap.this.key[this.index] + "=>" + Double2CharLinkedOpenHashMap.this.value[this.index];
        }
    }
}

