/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.boot;

import com.cenqua.fisheye.FishEyeCtl;
import com.cenqua.fisheye.boot.FileUtils;
import java.io.File;
import java.net.URL;

public final class BootUtils {
    public static File getAppHome() {
        String apphomeStr = System.getProperty("fisheye.home");
        File apphome = apphomeStr == null ? BootUtils.findAppHome() : new File(apphomeStr);
        return apphome;
    }

    public static File getAppInstance() {
        File fisheyeInst;
        String fisheyeInstStr = System.getProperty("fisheye.inst");
        if (fisheyeInstStr != null) {
            fisheyeInst = new File(fisheyeInstStr);
            if (fisheyeInst.exists() && !fisheyeInst.isDirectory()) {
                throw new IllegalArgumentException("ERROR: fisheye.inst is not a directory: " + fisheyeInst.getAbsolutePath());
            }
        } else {
            fisheyeInst = null;
        }
        return fisheyeInst;
    }

    private static File findAppHome() {
        File bootjar = BootUtils.getBootJarPath();
        if (bootjar.getName().endsWith(".jar")) {
            return bootjar.getParentFile();
        }
        return new File(".");
    }

    private static File getBootJarPath() {
        String pathToClass = "/" + FishEyeCtl.class.getName().replace('.', '/') + ".class";
        URL url = FishEyeCtl.class.getResource(pathToClass);
        if (url != null) {
            String path = url.toString();
            if (path.startsWith("jar:file:")) {
                int bang = path.indexOf("!");
                return new File(FileUtils.fromURI(path.substring(4, bang))).getAbsoluteFile();
            }
            if (path.startsWith("file:")) {
                int tail = path.indexOf(pathToClass);
                return new File(FileUtils.fromURI(path.substring(0, tail))).getAbsoluteFile();
            }
        }
        return null;
    }
}

