/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Key;
import com.persistit.util.Util;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

class ValueInspectorTreeNode
implements TreeNode {
    public static final long TO_STRING_TIMEOUT = 1000L;
    public static final int MAX_DISPLAYABLE_LENGTH = 512;
    private static WeakHashMap _fieldArrayMap = new WeakHashMap();
    private String _displayable;
    private final String _fieldName;
    private final Object _object;
    private String _toString;
    private final ValueInspectorTreeNode _parent;
    private int _index = -1;
    private final Class _type;
    private final ValueInspectorTreeNode[] _children;

    ValueInspectorTreeNode(ValueInspectorTreeNode parent, Object object, String name, Class type) {
        this._parent = parent;
        this._object = object;
        this._type = type;
        this._fieldName = name;
        int childCount = 0;
        if (type.isArray()) {
            if (object != null) {
                childCount = ValueInspectorTreeNode.arrayLength(type, object);
            }
        } else if (!type.isPrimitive()) {
            if (object != null) {
                childCount = this.getFields(type).length;
            }
            if (type.getSuperclass() != null && type.getSuperclass() != Object.class) {
                ++childCount;
            }
        }
        this._children = new ValueInspectorTreeNode[childCount];
    }

    ValueInspectorTreeNode(ValueInspectorTreeNode parent, Object object, String name, Class type, int index) {
        this(parent, object, name, type);
        this._index = index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String displayable(String fieldName, Class type, Object object, int arrayIndex) {
        StringBuilder sb = new StringBuilder();
        if (arrayIndex >= 0) {
            sb.append('[');
            sb.append(arrayIndex);
            sb.append(']');
        } else {
            sb.append(fieldName);
        }
        if (type.isPrimitive()) {
            if (arrayIndex == -1) {
                sb.append(" (");
                sb.append(type.getName());
                sb.append(")");
            }
            sb.append(" = ");
            if (type == Boolean.TYPE || type == Float.TYPE || type == Double.TYPE) {
                sb.append(object.toString());
            } else if (type == Byte.TYPE) {
                sb.append(object);
                sb.append(" [0x");
                Util.hex(sb, ((Byte)object).byteValue(), 2);
                sb.append("]");
            } else if (type == Short.TYPE) {
                sb.append(object);
                sb.append(" [0x");
                Util.hex(sb, ((Short)object).shortValue(), 4);
                sb.append("]");
            } else if (type == Character.TYPE) {
                sb.append(object);
                sb.append(" [0x");
                Util.hex(sb, ((Character)object).charValue(), 4);
                sb.append("]");
            } else if (type == Integer.TYPE) {
                sb.append(object);
                sb.append(" [0x");
                Util.hex(sb, ((Integer)object).intValue(), 8);
                sb.append("]");
            } else {
                if (type != Long.TYPE) throw new RuntimeException("type=" + type);
                sb.append(object);
                sb.append(" [0x");
                Util.hex(sb, (Long)object, 16);
                sb.append("]");
            }
        } else if (this._parent != null) {
            if (!type.isPrimitive() || this._index < 0) {
                sb.append(" (");
                if (type.isArray()) {
                    sb.append(this.componentTypeName(type));
                    sb.append('[');
                    sb.append(ValueInspectorTreeNode.arrayLength(type, object));
                    sb.append(']');
                    int index = this.dimensions(type);
                    while (index-- > 1) {
                        sb.append("[]");
                    }
                } else if (object == null) {
                    sb.append(type.getName());
                } else {
                    sb.append(object.getClass().getName());
                }
                sb.append(")");
            }
            if (object == null) {
                sb.append(" = null");
            } else if (object instanceof String) {
                sb.append(" = \"");
                Util.appendQuotedString(sb, object.toString(), 0, 512 - sb.length());
                sb.append('\"');
            } else if (object instanceof Date) {
                sb.append(" = ");
                sb.append(Key.SDF.format((Date)object));
            } else if (type == Boolean.class || type == Byte.class || type == Short.class || type == Character.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == BigInteger.class || type == BigDecimal.class) {
                sb.append(" = ");
                sb.append(object);
            }
            if (object != null && !object.getClass().isPrimitive()) {
                sb.append("  (id=");
                sb.append(System.identityHashCode(object));
                sb.append(")");
            }
        }
        if (sb.length() <= 512) return sb.toString();
        sb.setLength(512);
        sb.append("...");
        return sb.toString();
    }

    int dimensions(Class type) {
        int count = 0;
        while (type.isArray()) {
            ++count;
            type = type.getComponentType();
        }
        return count;
    }

    String componentTypeName(Class type) {
        if (type.isArray()) {
            return this.componentTypeName(type.getComponentType());
        }
        return type.getName();
    }

    static int arrayLength(Class type, Object object) {
        if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            if (elementType.isPrimitive()) {
                if (elementType == Boolean.TYPE) {
                    return ((boolean[])object).length;
                }
                if (elementType == Byte.TYPE) {
                    return ((byte[])object).length;
                }
                if (elementType == Short.TYPE) {
                    return ((short[])object).length;
                }
                if (elementType == Character.TYPE) {
                    return ((char[])object).length;
                }
                if (elementType == Integer.TYPE) {
                    return ((int[])object).length;
                }
                if (elementType == Long.TYPE) {
                    return ((long[])object).length;
                }
                if (elementType == Float.TYPE) {
                    return ((float[])object).length;
                }
                if (elementType == Double.TYPE) {
                    return ((double[])object).length;
                }
            } else {
                return ((Object[])object).length;
            }
        }
        return 0;
    }

    public Enumeration children() {
        if (this._object == null || this._type.isPrimitive()) {
            return null;
        }
        return new ChildEnumeration();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        if (this._object == null || this._type.isPrimitive()) {
            return null;
        }
        if (this._children[childIndex] == null) {
            this._children[childIndex] = this._type.isArray() ? this.getArrayChild(childIndex) : this.getFieldValue(childIndex);
        }
        return this._children[childIndex];
    }

    @Override
    public int getChildCount() {
        return this._children.length;
    }

    @Override
    public int getIndex(TreeNode node) {
        if (this._parent == null) {
            return -1;
        }
        ValueInspectorTreeNode[] siblings = this._parent._children;
        for (int index = 0; index < siblings.length; ++index) {
            if (node != siblings[index]) continue;
            return index;
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this._parent;
    }

    @Override
    public boolean isLeaf() {
        return this._children.length == 0;
    }

    public String toString() {
        if (this._displayable == null) {
            this._displayable = this.displayable(this._fieldName, this._type, this._object, this._index);
        }
        return this._displayable;
    }

    String getEvalString() {
        return this._toString;
    }

    void evalString(Runnable runnable) {
        new ToStringRunner(this._object, runnable).start();
    }

    private static String evalString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            Class<?> elementType = object.getClass().getComponentType();
            boolean primitive = elementType.isPrimitive();
            int size = ValueInspectorTreeNode.arrayLength(object.getClass(), object);
            sb.append("{");
            for (int index = 0; index < size; ++index) {
                if (index > 0) {
                    sb.append(", ");
                }
                if (primitive) {
                    if (elementType == Boolean.TYPE) {
                        sb.append(((boolean[])object)[index] ? Boolean.TRUE : Boolean.FALSE);
                        continue;
                    }
                    if (elementType == Byte.TYPE) {
                        sb.append(((byte[])object)[index]);
                        continue;
                    }
                    if (elementType == Short.TYPE) {
                        sb.append(((short[])object)[index]);
                        continue;
                    }
                    if (elementType == Character.TYPE) {
                        sb.append((int)((char[])object)[index]);
                        continue;
                    }
                    if (elementType == Integer.TYPE) {
                        sb.append(((int[])object)[index]);
                        continue;
                    }
                    if (elementType == Long.TYPE) {
                        sb.append(((long[])object)[index]);
                        continue;
                    }
                    if (elementType == Float.TYPE) {
                        sb.append(((float[])object)[index]);
                        continue;
                    }
                    if (elementType == Double.TYPE) {
                        sb.append(((double[])object)[index]);
                        continue;
                    }
                    throw new RuntimeException();
                }
                sb.append(ValueInspectorTreeNode.evalString(((Object[])object)[index]));
            }
            sb.append("}");
            return sb.toString();
        }
        if (object instanceof String) {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            Util.appendQuotedString(sb, object.toString(), 0, Integer.MAX_VALUE);
            sb.append('\"');
            return sb.toString();
        }
        try {
            return object.toString();
        }
        catch (Throwable t) {
            return t + " while invoking " + object.getClass().getName() + ".toString()";
        }
    }

    private ValueInspectorTreeNode getFieldValue(int index) {
        if (this._type.getSuperclass() != null && this._type.getSuperclass() != Object.class) {
            if (index == 0) {
                return new ValueInspectorTreeNode(this, this._object, this._type.getSuperclass().toString(), this._type.getSuperclass());
            }
            --index;
        }
        Object childValue = null;
        Field field = this.getFields(this._type)[index];
        try {
            childValue = field.get(this._object);
        }
        catch (IllegalAccessException iae) {
            childValue = "{{" + iae.toString() + "}}";
        }
        this._children[index] = new ValueInspectorTreeNode(this, childValue, field.getName(), field.getType());
        return this._children[index];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ValueInspectorTreeNode getArrayChild(int index) {
        Object element;
        Class<?> elementType = this._type.getComponentType();
        if (elementType.isPrimitive()) {
            if (elementType == Boolean.TYPE) {
                element = ((boolean[])this._object)[index] ? Boolean.TRUE : Boolean.FALSE;
            } else if (elementType == Byte.TYPE) {
                element = new Byte(((byte[])this._object)[index]);
            } else if (elementType == Short.TYPE) {
                element = new Short(((short[])this._object)[index]);
            } else if (elementType == Character.TYPE) {
                element = new Character(((char[])this._object)[index]);
            } else if (elementType == Integer.TYPE) {
                element = new Integer(((int[])this._object)[index]);
            } else if (elementType == Long.TYPE) {
                element = new Long(((long[])this._object)[index]);
            } else if (elementType == Float.TYPE) {
                element = new Float(((float[])this._object)[index]);
            } else {
                if (elementType != Double.TYPE) throw new RuntimeException();
                element = new Double(((double[])this._object)[index]);
            }
        } else {
            element = ((Object[])this._object)[index];
        }
        Class<?> type = elementType.isPrimitive() || element == null ? elementType : element.getClass();
        return new ValueInspectorTreeNode(this, element, "[" + index + "]", type, index);
    }

    private Field[] getFields(Class type) {
        AccessibleObject[] array = (Field[])_fieldArrayMap.get(type.getName());
        if (array == null) {
            array = type.getDeclaredFields();
            ArrayList<Field> selected = new ArrayList<Field>();
            for (int index = 0; index < array.length; ++index) {
                Field field = array[index];
                if (Modifier.isStatic(field.getModifiers())) continue;
                selected.add(field);
            }
            array = selected.toArray(new Field[selected.size()]);
            Arrays.sort(array, new FieldComparator());
            AccessibleObject.setAccessible(array, true);
            _fieldArrayMap.put(type.getName(), array);
        }
        return array;
    }

    private class ToStringRunner
    extends Thread {
        private final Object _object;
        private final Runnable _runnable;
        private boolean _done;

        ToStringRunner(Object object, Runnable runnable) {
            this._object = object;
            this._runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ValueInspectorTreeNode.this._toString = null;
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (!ToStringRunner.this._done) {
                            ValueInspectorTreeNode.this._toString = "???";
                            ToStringRunner.this.stop();
                        }
                    }
                }, 1000L);
                ValueInspectorTreeNode.this._toString = ValueInspectorTreeNode.evalString(this._object);
                this._done = true;
                timer.cancel();
            }
            finally {
                SwingUtilities.invokeLater(this._runnable);
            }
        }
    }

    private class ChildEnumeration
    implements Enumeration {
        int _enumerationIndex = 0;

        private ChildEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this._enumerationIndex < ValueInspectorTreeNode.this._children.length;
        }

        public Object nextElement() {
            return ValueInspectorTreeNode.this.getChildAt(this._enumerationIndex++);
        }
    }

    private class FieldComparator
    implements Comparator {
        private FieldComparator() {
        }

        public int compare(Object a, Object b) {
            Field fieldA = (Field)a;
            Field fieldB = (Field)b;
            String nameA = fieldA.getName();
            String nameB = fieldB.getName();
            return nameA.compareTo(nameB);
        }
    }
}

