/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;

class VTComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private final VTComboBoxModel _parent;
    private final List _cachedList = new ArrayList();
    private Object _selectedItem;
    private long _validTime;
    private final Management _management;

    public VTComboBoxModel(VTComboBoxModel vtcmb, Management management) {
        this._parent = vtcmb;
        this._management = management;
    }

    @Override
    public Object getElementAt(int index) {
        this.populateList();
        if (index >= 0 && index < this._cachedList.size()) {
            return this._cachedList.get(index);
        }
        return null;
    }

    @Override
    public int getSize() {
        this.populateList();
        return this._cachedList.size();
    }

    @Override
    public void setSelectedItem(Object item) {
        this._selectedItem = item;
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedItem;
    }

    private void populateList() {
        long now = System.currentTimeMillis();
        if (now - this._validTime < 1000L) {
            return;
        }
        this._validTime = now;
        this._cachedList.clear();
        try {
            if (this._parent == null) {
                Management.VolumeInfo[] volumes = this._management.getVolumeInfoArray();
                for (int index = 0; index < volumes.length; ++index) {
                    this._cachedList.add(volumes[index].getName());
                }
            } else {
                String volumeName = (String)this._parent.getSelectedItem();
                if (volumeName == null) {
                    return;
                }
                Management.TreeInfo[] trees = this._management.getTreeInfoArray(volumeName);
                for (int index = 0; index < trees.length; ++index) {
                    this._cachedList.add(trees[index].getName());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception e) {
        e.printStackTrace();
    }
}

