/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Management;
import com.persistit.ui.AdminCommand;
import com.persistit.ui.AdminPanel;
import com.persistit.ui.AdminUI;
import com.persistit.ui.ManagementListModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TreeAndVolumeSelector
extends AdminPanel
implements AdminCommand {
    private static final long serialVersionUID = 1L;
    private static final String PROTOTYPE_VOLUME_NAME = "/this/that/persistit";
    private static final String PROTOTYPE_TREE_NAME = "aTreeName (/var/lib/this/that/other)";
    private static final int VISIBLE_ROW_COUNT = 12;
    AdminUI _adminUI;
    private JList _volumeList;
    private JList _treeList;
    private JList _selectedTreeList;
    private final DefaultListModel _treeListModel = new DefaultListModel();
    private final DefaultListModel _selectedTreeListModel = new DefaultListModel();
    private JButton _addAllAllButton;
    private JButton _addSelectedButton;
    private JButton _removeSelectedButton;
    private JButton _addAllButton;
    private JButton _removeAllButton;
    private AdminUI.AdminAction _addAllAllAction;
    private AdminUI.AdminAction _addSelectedAction;
    private AdminUI.AdminAction _removeSelectedAction;
    private AdminUI.AdminAction _addAllAction;
    private AdminUI.AdminAction _removeAllAction;
    private ManagementListModel _volumeInfoArrayModel;
    private String _selectedVolumeName;
    private boolean _refreshing;

    @Override
    public void setup(AdminUI ui) {
        this._adminUI = ui;
        this._addSelectedAction = ui.createAction(this, this._adminUI.getProperty("TVSelector.AddSelected"));
        this._removeSelectedAction = ui.createAction(this, this._adminUI.getProperty("TVSelector.RemoveSelected"));
        this._addAllAction = ui.createAction(this, this._adminUI.getProperty("TVSelector.AddAll"));
        this._addAllAllAction = ui.createAction(this, this._adminUI.getProperty("TVSelector.AddAllAll"));
        this._removeAllAction = ui.createAction(this, this._adminUI.getProperty("TVSelector.RemoveAll"));
        this._addAllAllButton = new JButton(this._addAllAllAction);
        this._addSelectedButton = new JButton(this._addSelectedAction);
        this._removeSelectedButton = new JButton(this._removeSelectedAction);
        this._addAllButton = new JButton(this._addAllAction);
        this._removeAllButton = new JButton(this._removeAllAction);
        this._volumeInfoArrayModel = new ManagementListModel();
        this._volumeList = new JList(this._volumeInfoArrayModel);
        this._volumeList.setPrototypeCellValue(PROTOTYPE_VOLUME_NAME);
        this._treeList = new JList(this._treeListModel);
        this._treeList.setPrototypeCellValue(PROTOTYPE_TREE_NAME);
        this._treeList.setCellRenderer(new TreeItemListCellRenderer(true, this._treeList));
        this._selectedTreeList = new JList(this._selectedTreeListModel);
        this._selectedTreeList.setPrototypeCellValue(PROTOTYPE_TREE_NAME);
        this._selectedTreeList.setCellRenderer(new TreeItemListCellRenderer(false, this._selectedTreeList));
        this._volumeList.setSelectionMode(0);
        this._volumeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int index = TreeAndVolumeSelector.this._volumeList.getSelectedIndex();
                if (!lse.getValueIsAdjusting() && !TreeAndVolumeSelector.this._refreshing && index >= 0) {
                    Management.VolumeInfo[] array = (Management.VolumeInfo[])TreeAndVolumeSelector.this._volumeInfoArrayModel.getInfoArray();
                    if (array != null && index < array.length) {
                        TreeAndVolumeSelector.this.selectVolume(array[index]);
                    } else {
                        TreeAndVolumeSelector.this.selectVolume(null);
                    }
                    TreeAndVolumeSelector.this.refresh(false);
                }
            }
        });
        this._treeList.setSelectionMode(2);
        this._treeList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                if (lse.getValueIsAdjusting() || !TreeAndVolumeSelector.this._refreshing) {
                    // empty if block
                }
            }
        });
        this._volumeList.setVisibleRowCount(12);
        this._treeList.setVisibleRowCount(12);
        this._selectedTreeList.setVisibleRowCount(12);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this._addAllAllButton, gbc);
        ++gbc.gridy;
        buttonPanel.add(Box.createVerticalStrut(8), gbc);
        ++gbc.gridy;
        buttonPanel.add((Component)this._addAllButton, gbc);
        ++gbc.gridy;
        buttonPanel.add((Component)this._addSelectedButton, gbc);
        ++gbc.gridy;
        buttonPanel.add(Box.createVerticalStrut(8), gbc);
        ++gbc.gridy;
        buttonPanel.add((Component)this._removeSelectedButton, gbc);
        ++gbc.gridy;
        buttonPanel.add((Component)this._removeAllButton, gbc);
        ++gbc.gridy;
        buttonPanel.add(Box.createVerticalStrut(8), gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane(this._volumeList), gbc);
        ++gbc.gridx;
        this.add((Component)new JScrollPane(this._treeList), gbc);
        ++gbc.gridx;
        this.add((Component)buttonPanel, gbc);
        gbc.weightx = 1.0;
        ++gbc.gridx;
        this.add((Component)new JScrollPane(this._selectedTreeList), gbc);
    }

    private boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    private void selectVolume(Management.VolumeInfo volumeInfo) {
        String newName;
        String string = newName = volumeInfo == null ? null : volumeInfo.getName();
        if (!this.equals(newName, this._selectedVolumeName)) {
            this._selectedVolumeName = newName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void refresh(boolean reset) {
        TreeAndVolumeSelector treeAndVolumeSelector = this;
        synchronized (treeAndVolumeSelector) {
            if (this._refreshing) {
                return;
            }
            this._refreshing = true;
        }
        try {
            Management management = this._adminUI.getManagement();
            if (reset) {
                this._selectedVolumeName = null;
            }
            Object[] volumeInfoArray = null;
            if (management != null) {
                volumeInfoArray = management.getVolumeInfoArray();
            }
            this._volumeInfoArrayModel.setInfoArray(volumeInfoArray);
            Management.TreeInfo[] treeInfoArray = null;
            if (management != null && this._selectedVolumeName != null) {
                treeInfoArray = management.getTreeInfoArray(this._selectedVolumeName);
            }
            this.updateTreeListModel(this._selectedVolumeName, treeInfoArray);
        }
        catch (RemoteException re) {
            this._adminUI.postException(re);
        }
        finally {
            TreeAndVolumeSelector treeAndVolumeSelector2 = this;
            synchronized (treeAndVolumeSelector2) {
                this._refreshing = false;
            }
        }
    }

    private void updateTreeListModel(String volumeName, Management.TreeInfo[] array) {
        this._treeListModel.clear();
        if (array == null) {
            return;
        }
        for (int index = 0; index < array.length; ++index) {
            Management.TreeInfo info = array[index];
            TreeItem item = new TreeItem();
            item._volumeName = volumeName;
            item._treeName = info.getName();
            int selectedSize = this._selectedTreeListModel.size();
            boolean alreadySelected = false;
            for (int selectedIndex = 0; selectedIndex < selectedSize; ++selectedIndex) {
                if (!this._selectedTreeListModel.getElementAt(selectedIndex).equals(item)) continue;
                alreadySelected = true;
                break;
            }
            item._selected = alreadySelected;
            this._treeListModel.addElement(item);
        }
    }

    @Override
    public Map getMenuMap() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void setDefaultButton() {
    }

    @Override
    public void actionPerformed(AdminUI.AdminAction action, ActionEvent ae) {
        String name = action.getName();
        if ("ADD_SELECTED".equals(name)) {
            int[] selected = this._treeList.getSelectedIndices();
            for (int index = 0; index < selected.length; ++index) {
                int itemIndex = selected[index];
                TreeItem item = (TreeItem)this._treeListModel.getElementAt(itemIndex);
                if (item._selected) continue;
                item._selected = true;
                this._selectedTreeListModel.addElement(item);
            }
            this._treeList.repaint();
        } else if ("REMOVE_SELECTED".equals(name)) {
            int[] selected = this._selectedTreeList.getSelectedIndices();
            int index = selected.length;
            while (--index >= 0) {
                int itemIndex = selected[index];
                TreeItem item = (TreeItem)this._selectedTreeListModel.getElementAt(itemIndex);
                if (!item._selected) continue;
                item._selected = false;
                this._selectedTreeListModel.removeElementAt(itemIndex);
            }
            this._treeList.repaint();
        } else if ("ADD_ALL".equals(name)) {
            int size = this._treeListModel.size();
            for (int index = 0; index < size; ++index) {
                TreeItem item = (TreeItem)this._treeListModel.getElementAt(index);
                if (item._selected) continue;
                item._selected = true;
                this._selectedTreeListModel.addElement(item);
            }
            this._treeList.repaint();
        } else if ("REMOVE_ALL".equals(name)) {
            int size;
            int index = size = this._selectedTreeListModel.size();
            while (--index >= 0) {
                TreeItem item = (TreeItem)this._selectedTreeListModel.getElementAt(index);
                if (!item._selected) continue;
                item._selected = false;
                this._selectedTreeListModel.removeElementAt(index);
            }
            this._treeList.repaint();
        } else if ("ADD_ALL_ALL".equals(name)) {
            this._volumeList.clearSelection();
            this._treeListModel.clear();
            this._selectedTreeListModel.clear();
            int volumeCount = this._volumeList.getModel().getSize();
            Management management = this._adminUI.getManagement();
            if (management != null) {
                for (int volumeIndex = 0; volumeIndex < volumeCount; ++volumeIndex) {
                    Management.VolumeInfo volumeInfo = (Management.VolumeInfo)this._volumeList.getModel().getElementAt(volumeIndex);
                    String volumeName = volumeInfo.getName();
                    try {
                        Management.TreeInfo[] treeInfoArray = management.getTreeInfoArray(volumeName);
                        for (int treeIndex = 0; treeIndex < treeInfoArray.length; ++treeIndex) {
                            TreeItem item = new TreeItem();
                            item._volumeName = volumeName;
                            item._treeName = treeInfoArray[treeIndex].getName();
                            item._selected = true;
                            this._selectedTreeListModel.addElement(item);
                        }
                        continue;
                    }
                    catch (RemoteException re) {
                        this._adminUI.postException(re);
                        break;
                    }
                }
            }
        }
    }

    public String getTreeListString() {
        StringBuilder sb = new StringBuilder();
        int size = this._selectedTreeListModel.size();
        for (int index = 0; index < size; ++index) {
            TreeItem item = (TreeItem)this._selectedTreeListModel.elementAt(index);
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(this.quote(item._volumeName));
            sb.append(':');
            sb.append(this.quote(item._treeName));
        }
        return sb.toString();
    }

    private String quote(String s) {
        if (s.indexOf(92) == 0 && s.indexOf(44) == 0 && s.indexOf(59) == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < s.length(); ++index) {
            char c = s.charAt(index);
            if (c == '\\' || c == ',' || c == ';') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static class TreeItemListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        boolean _supplySide;
        StringBuilder sb = new StringBuilder();
        Color _defaultBackground;
        Color _defaultForeground;
        Color _disabledForeground;
        Color _disabledBackground;
        Color _enabledSelectedBackground;
        Color _enabledSelectedForeground;
        Color _disabledSelectedBackground;
        Color _disabledSelectedForeground;

        TreeItemListCellRenderer(boolean supplySide, JList list) {
            this._supplySide = supplySide;
            this._defaultBackground = list.getBackground();
            this._defaultForeground = list.getForeground();
            this._disabledForeground = Color.gray;
            this._disabledBackground = this._defaultBackground;
            this._enabledSelectedBackground = list.getSelectionBackground();
            this._enabledSelectedForeground = list.getSelectionForeground();
            this._disabledSelectedBackground = Color.lightGray;
            this._disabledSelectedForeground = Color.darkGray;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (!(value instanceof TreeItem)) {
                this.setText(value.toString());
                this.setBackground(isSelected ? this._enabledSelectedBackground : this._defaultBackground);
                this.setForeground(isSelected ? this._enabledSelectedForeground : this._defaultForeground);
            } else {
                Color background;
                TreeItem item = (TreeItem)value;
                this.sb.setLength(0);
                this.sb.append(item._treeName);
                this.sb.append(" (");
                this.sb.append(item._volumeName);
                this.sb.append(")");
                this.setText(this.sb.toString());
                boolean enabled = item._selected ^ this._supplySide;
                Color color = isSelected ? (enabled ? this._enabledSelectedBackground : this._disabledSelectedBackground) : (background = enabled ? this._defaultBackground : this._disabledBackground);
                Color foreground = isSelected ? (enabled ? this._enabledSelectedForeground : this._disabledSelectedForeground) : (enabled ? this._defaultForeground : this._disabledForeground);
                this.setBackground(background);
                this.setForeground(foreground);
            }
            return this;
        }
    }

    private static class TreeItem {
        String _treeName;
        String _volumeName;
        boolean _selected;

        private TreeItem() {
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TreeItem)) {
                return false;
            }
            TreeItem ti = (TreeItem)obj;
            return ti._treeName.equals(this._treeName) && ti._volumeName.equals(this._volumeName);
        }
    }
}

