/*
 * Decompiled with CFR 0.152.
 */
package com.persistit.ui;

import com.persistit.Key;
import com.persistit.KeyState;
import com.persistit.Persistit;
import com.persistit.Value;
import com.persistit.ValueState;
import com.persistit.ui.AdminUI;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ManagementTableModel
extends AbstractTableModel {
    protected static final Class[] NO_ARG_TEMPLATE = new Class[0];
    protected static final Object[] NO_ARG_LIST = new Object[0];
    protected AdminUI _adminUI;
    protected int _columnCount;
    protected int _displayedColumnCount;
    protected boolean[] _displayedColumns;
    protected int[] _displayedColumnIndex;
    protected String[] _flags;
    protected Method[] _methods;
    protected int[] _widths;
    protected String[] _headers;
    protected TableCellRenderer[] _renderers;
    protected int _totalWidth;
    protected Object[] _infoArray;

    public ManagementTableModel(Class clazz, String className, AdminUI ui) throws NoSuchMethodException {
        String propName;
        String value;
        this._adminUI = ui;
        int p = className.lastIndexOf(46);
        if (p >= 0) {
            className = className.substring(p + 1);
        }
        ArrayList<String> specList = new ArrayList<String>();
        int index = 0;
        while ((value = ui.getProperty(propName = className + ".column." + index)) != null && !value.startsWith(".")) {
            specList.add(value);
            ++index;
        }
        String[] columnSpecs = specList.toArray(new String[0]);
        this.setup(clazz, columnSpecs);
    }

    protected void setup(Class clazz, String[] columnSpecs) throws NoSuchMethodException {
        this._columnCount = columnSpecs.length;
        this._displayedColumnCount = 0;
        this._displayedColumns = new boolean[this._columnCount];
        this._displayedColumnIndex = new int[this._columnCount];
        this._widths = new int[this._columnCount];
        this._flags = new String[this._columnCount];
        this._headers = new String[this._columnCount];
        this._methods = new Method[this._columnCount];
        this._renderers = new TableCellRenderer[this._columnCount];
        for (int index = 0; index < columnSpecs.length; ++index) {
            StringTokenizer st = new StringTokenizer(columnSpecs[index], ":");
            String methodName = st.nextToken();
            int width = Integer.parseInt(st.nextToken());
            String flags = st.nextToken();
            String header = st.nextToken();
            String rendererName = null;
            int minWidth = width / 2;
            if (st.hasMoreTokens()) {
                minWidth = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                rendererName = st.nextToken();
            }
            this._totalWidth += width;
            this._widths[index] = width;
            this._flags[index] = flags;
            this._methods[index] = clazz.getMethod(methodName, NO_ARG_TEMPLATE);
            if (rendererName != null) {
                this._renderers[index] = this.constructRenderer(rendererName, clazz, columnSpecs[index]);
            }
            this._headers[index] = header;
        }
    }

    public void setInfoArray(Object[] array) {
        this._infoArray = array;
        this.fireTableDataChanged();
    }

    public Object[] getInfoArray() {
        return this._infoArray;
    }

    @Override
    public int getColumnCount() {
        return this._displayedColumnCount;
    }

    @Override
    public int getRowCount() {
        if (this._infoArray == null) {
            return 0;
        }
        return this._infoArray.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this._infoArray == null || row < 0 || row >= this._infoArray.length) {
            return null;
        }
        if (col == -1) {
            return this._infoArray[row];
        }
        try {
            Object struct = this._infoArray[row];
            int index = this._displayedColumnIndex[col];
            if (index < 0) {
                return null;
            }
            Object value = this._methods[index].invoke(struct, NO_ARG_LIST);
            return value;
        }
        catch (Exception e) {
            return e;
        }
    }

    public void formatColumns(JTable table, String flags) {
        int trueCount = 0;
        boolean changed = false;
        for (int i = 0; i < this._columnCount; ++i) {
            boolean value;
            boolean bl = value = this._flags[i].indexOf(65) >= 0;
            if (flags != null) {
                int j = flags.length();
                while (!value && --j > 0) {
                    if (this._flags[i].indexOf(flags.charAt(j)) < 0) continue;
                    value = true;
                }
            }
            if (value) {
                ++trueCount;
            }
            if (value == this._displayedColumns[i]) continue;
            this._displayedColumns[i] = value;
            changed = true;
        }
        if (this._displayedColumnCount != trueCount) {
            changed = true;
        }
        this._displayedColumnCount = trueCount;
        if (changed) {
            TableColumnModel tcm = table.getColumnModel();
            int count = tcm.getColumnCount();
            if (count > this._displayedColumnCount) {
                int i = this._displayedColumnCount;
                while (--i >= count) {
                    tcm.removeColumn(tcm.getColumn(i));
                }
            }
            int index = 0;
            for (int i = 0; i < this._columnCount; ++i) {
                TableColumn tc;
                if (!this._displayedColumns[i]) continue;
                if (index >= count) {
                    tc = new TableColumn();
                    tcm.addColumn(tc);
                } else {
                    tc = tcm.getColumn(index);
                }
                tc.setHeaderValue(this._headers[i]);
                tc.setPreferredWidth(this._widths[i] % 10000);
                tc.setMinWidth(this._widths[i] / 10000);
                this._displayedColumnIndex[index] = i;
                tc.setModelIndex(index);
                if (this._renderers[i] != null) {
                    tc.setCellRenderer(this._renderers[i]);
                }
                ++index;
            }
            table.setDefaultRenderer(Double.class, new DoubleRenderer());
            table.setDefaultRenderer(Long.class, new LongRenderer());
            table.setDefaultRenderer(Integer.class, new IntegerRenderer());
            table.setDefaultRenderer(KeyState.class, new KeyStateRenderer());
            table.setDefaultRenderer(ValueState.class, new ValueStateRenderer());
            this.fireTableStructureChanged();
        }
        table.setAutoResizeMode(0);
    }

    public Class getColumnClass(int col) {
        int index = this._displayedColumnIndex[col];
        Class<?> clazz = this._methods[index].getReturnType();
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
        }
        return clazz;
    }

    protected TableCellRenderer constructRenderer(String rendererName, Class infoClass, String columnSpec) {
        String className = this.getClass().getName();
        className = className.substring(0, className.lastIndexOf(46)) + ".renderers." + rendererName;
        try {
            Class<?> clazz = Class.forName(className);
            Object object = clazz.newInstance();
            if (object instanceof AbstractCustomTableCellRenderer) {
                ((AbstractCustomTableCellRenderer)object).setup(this._adminUI, infoClass, columnSpec);
                return (TableCellRenderer)object;
            }
        }
        catch (Exception e) {
            this._adminUI.postException(e);
        }
        return null;
    }

    public static abstract class AbstractCustomTableCellRenderer
    extends DefaultTableCellRenderer {
        protected abstract void setup(AdminUI var1, Class var2, String var3);
    }

    class ValueStateRenderer
    extends AlignedCellRenderer {
        private final Value _value;

        public ValueStateRenderer() {
            super(2);
            this._value = new Value((Persistit)null);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof ValueState) {
                ((ValueState)value).copyTo(this._value);
                this.setText(this._value.toString());
            } else {
                this.setText(value.toString());
            }
        }
    }

    class KeyStateRenderer
    extends AlignedCellRenderer {
        private final Key _key;

        public KeyStateRenderer() {
            super(2);
            this._key = new Key((Persistit)null);
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof KeyState) {
                ((KeyState)value).copyTo(this._key);
                this.setText(this._key.toString());
            } else {
                this.setText(value.toString());
            }
        }
    }

    class DoubleRenderer
    extends AlignedCellRenderer {
        public DoubleRenderer() {
            super(4);
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : (value instanceof Double ? ManagementTableModel.this._adminUI.formatPercent((Double)value) : value.toString()));
        }
    }

    class IntegerRenderer
    extends AlignedCellRenderer {
        public IntegerRenderer() {
            super(4);
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : (value instanceof Integer ? ManagementTableModel.this._adminUI.formatInteger((Integer)value) : value.toString()));
        }
    }

    class LongRenderer
    extends AlignedCellRenderer {
        public LongRenderer() {
            super(4);
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : (value instanceof Long ? ManagementTableModel.this._adminUI.formatLong((Long)value) : value.toString()));
        }
    }

    class AlignedCellRenderer
    extends DefaultTableCellRenderer {
        AlignedCellRenderer(int alignment) {
            this.setHorizontalAlignment(alignment);
        }
    }
}

